/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class TcpKeepAliveConfiguration {
    private final Duration keepAliveInterval;
    private final Duration keepAliveTimeout;

    private TcpKeepAliveConfiguration(DefaultTcpKeepAliveConfigurationBuilder builder) {
        this.keepAliveInterval = Validate.isPositive((Duration)builder.keepAliveInterval, (String)"keepAliveInterval");
        this.keepAliveTimeout = Validate.isPositive((Duration)builder.keepAliveTimeout, (String)"keepAliveTimeout");
    }

    public Duration keepAliveInterval() {
        return this.keepAliveInterval;
    }

    public Duration keepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public static Builder builder() {
        return new DefaultTcpKeepAliveConfigurationBuilder();
    }

    private static final class DefaultTcpKeepAliveConfigurationBuilder
    implements Builder {
        private Duration keepAliveInterval;
        private Duration keepAliveTimeout;

        private DefaultTcpKeepAliveConfigurationBuilder() {
        }

        @Override
        public Builder keepAliveInterval(Duration keepAliveInterval) {
            this.keepAliveInterval = keepAliveInterval;
            return this;
        }

        @Override
        public Builder keepAliveTimeout(Duration keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
            return this;
        }

        @Override
        public TcpKeepAliveConfiguration build() {
            return new TcpKeepAliveConfiguration(this);
        }
    }

    public static interface Builder {
        public Builder keepAliveInterval(Duration var1);

        public Builder keepAliveTimeout(Duration var1);

        public TcpKeepAliveConfiguration build();
    }
}

