/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.VaultState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRestoreAccessBackupVaultResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, CreateRestoreAccessBackupVaultResponse> {
    private static final SdkField<String> RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreAccessBackupVaultArn").getter(CreateRestoreAccessBackupVaultResponse.getter(CreateRestoreAccessBackupVaultResponse::restoreAccessBackupVaultArn)).setter(CreateRestoreAccessBackupVaultResponse.setter(Builder::restoreAccessBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreAccessBackupVaultArn").build()}).build();
    private static final SdkField<String> VAULT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultState").getter(CreateRestoreAccessBackupVaultResponse.getter(CreateRestoreAccessBackupVaultResponse::vaultStateAsString)).setter(CreateRestoreAccessBackupVaultResponse.setter(Builder::vaultState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultState").build()}).build();
    private static final SdkField<String> RESTORE_ACCESS_BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestoreAccessBackupVaultName").getter(CreateRestoreAccessBackupVaultResponse.getter(CreateRestoreAccessBackupVaultResponse::restoreAccessBackupVaultName)).setter(CreateRestoreAccessBackupVaultResponse.setter(Builder::restoreAccessBackupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreAccessBackupVaultName").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(CreateRestoreAccessBackupVaultResponse.getter(CreateRestoreAccessBackupVaultResponse::creationDate)).setter(CreateRestoreAccessBackupVaultResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD, VAULT_STATE_FIELD, RESTORE_ACCESS_BACKUP_VAULT_NAME_FIELD, CREATION_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRestoreAccessBackupVaultResponse.memberNameToFieldInitializer();
    private final String restoreAccessBackupVaultArn;
    private final String vaultState;
    private final String restoreAccessBackupVaultName;
    private final Instant creationDate;

    private CreateRestoreAccessBackupVaultResponse(BuilderImpl builder) {
        super(builder);
        this.restoreAccessBackupVaultArn = builder.restoreAccessBackupVaultArn;
        this.vaultState = builder.vaultState;
        this.restoreAccessBackupVaultName = builder.restoreAccessBackupVaultName;
        this.creationDate = builder.creationDate;
    }

    public final String restoreAccessBackupVaultArn() {
        return this.restoreAccessBackupVaultArn;
    }

    public final VaultState vaultState() {
        return VaultState.fromValue(this.vaultState);
    }

    public final String vaultStateAsString() {
        return this.vaultState;
    }

    public final String restoreAccessBackupVaultName() {
        return this.restoreAccessBackupVaultName;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreAccessBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreAccessBackupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRestoreAccessBackupVaultResponse)) {
            return false;
        }
        CreateRestoreAccessBackupVaultResponse other = (CreateRestoreAccessBackupVaultResponse)((Object)obj);
        return Objects.equals(this.restoreAccessBackupVaultArn(), other.restoreAccessBackupVaultArn()) && Objects.equals(this.vaultStateAsString(), other.vaultStateAsString()) && Objects.equals(this.restoreAccessBackupVaultName(), other.restoreAccessBackupVaultName()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRestoreAccessBackupVaultResponse").add("RestoreAccessBackupVaultArn", (Object)this.restoreAccessBackupVaultArn()).add("VaultState", (Object)this.vaultStateAsString()).add("RestoreAccessBackupVaultName", (Object)this.restoreAccessBackupVaultName()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestoreAccessBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.restoreAccessBackupVaultArn()));
            }
            case "VaultState": {
                return Optional.ofNullable(clazz.cast(this.vaultStateAsString()));
            }
            case "RestoreAccessBackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.restoreAccessBackupVaultName()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RestoreAccessBackupVaultArn", RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD);
        map.put("VaultState", VAULT_STATE_FIELD);
        map.put("RestoreAccessBackupVaultName", RESTORE_ACCESS_BACKUP_VAULT_NAME_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRestoreAccessBackupVaultResponse, T> g) {
        return obj -> g.apply((CreateRestoreAccessBackupVaultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String restoreAccessBackupVaultArn;
        private String vaultState;
        private String restoreAccessBackupVaultName;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRestoreAccessBackupVaultResponse model) {
            super(model);
            this.restoreAccessBackupVaultArn(model.restoreAccessBackupVaultArn);
            this.vaultState(model.vaultState);
            this.restoreAccessBackupVaultName(model.restoreAccessBackupVaultName);
            this.creationDate(model.creationDate);
        }

        public final String getRestoreAccessBackupVaultArn() {
            return this.restoreAccessBackupVaultArn;
        }

        public final void setRestoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
        }

        @Override
        public final Builder restoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
            return this;
        }

        public final String getVaultState() {
            return this.vaultState;
        }

        public final void setVaultState(String vaultState) {
            this.vaultState = vaultState;
        }

        @Override
        public final Builder vaultState(String vaultState) {
            this.vaultState = vaultState;
            return this;
        }

        @Override
        public final Builder vaultState(VaultState vaultState) {
            this.vaultState(vaultState == null ? null : vaultState.toString());
            return this;
        }

        public final String getRestoreAccessBackupVaultName() {
            return this.restoreAccessBackupVaultName;
        }

        public final void setRestoreAccessBackupVaultName(String restoreAccessBackupVaultName) {
            this.restoreAccessBackupVaultName = restoreAccessBackupVaultName;
        }

        @Override
        public final Builder restoreAccessBackupVaultName(String restoreAccessBackupVaultName) {
            this.restoreAccessBackupVaultName = restoreAccessBackupVaultName;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        @Override
        public CreateRestoreAccessBackupVaultResponse build() {
            return new CreateRestoreAccessBackupVaultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRestoreAccessBackupVaultResponse> {
        public Builder restoreAccessBackupVaultArn(String var1);

        public Builder vaultState(String var1);

        public Builder vaultState(VaultState var1);

        public Builder restoreAccessBackupVaultName(String var1);

        public Builder creationDate(Instant var1);
    }
}

