/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.CopyJobState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCopyJobsRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, ListCopyJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::nextToken)).setter(ListCopyJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::maxResults)).setter(ListCopyJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> BY_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByResourceArn").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byResourceArn)).setter(ListCopyJobsRequest.setter(Builder::byResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceArn").build()}).build();
    private static final SdkField<String> BY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByState").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byStateAsString)).setter(ListCopyJobsRequest.setter(Builder::byState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()}).build();
    private static final SdkField<Instant> BY_CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCreatedBefore").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byCreatedBefore)).setter(ListCopyJobsRequest.setter(Builder::byCreatedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdBefore").build()}).build();
    private static final SdkField<Instant> BY_CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCreatedAfter").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byCreatedAfter)).setter(ListCopyJobsRequest.setter(Builder::byCreatedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("createdAfter").build()}).build();
    private static final SdkField<String> BY_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByResourceType").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byResourceType)).setter(ListCopyJobsRequest.setter(Builder::byResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final SdkField<String> BY_DESTINATION_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByDestinationVaultArn").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byDestinationVaultArn)).setter(ListCopyJobsRequest.setter(Builder::byDestinationVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("destinationVaultArn").build()}).build();
    private static final SdkField<String> BY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByAccountId").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byAccountId)).setter(ListCopyJobsRequest.setter(Builder::byAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("accountId").build()}).build();
    private static final SdkField<Instant> BY_COMPLETE_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCompleteBefore").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byCompleteBefore)).setter(ListCopyJobsRequest.setter(Builder::byCompleteBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completeBefore").build()}).build();
    private static final SdkField<Instant> BY_COMPLETE_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCompleteAfter").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byCompleteAfter)).setter(ListCopyJobsRequest.setter(Builder::byCompleteAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("completeAfter").build()}).build();
    private static final SdkField<String> BY_PARENT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByParentJobId").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byParentJobId)).setter(ListCopyJobsRequest.setter(Builder::byParentJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("parentJobId").build()}).build();
    private static final SdkField<String> BY_MESSAGE_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByMessageCategory").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::byMessageCategory)).setter(ListCopyJobsRequest.setter(Builder::byMessageCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("messageCategory").build()}).build();
    private static final SdkField<String> BY_SOURCE_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BySourceRecoveryPointArn").getter(ListCopyJobsRequest.getter(ListCopyJobsRequest::bySourceRecoveryPointArn)).setter(ListCopyJobsRequest.setter(Builder::bySourceRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sourceRecoveryPointArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, BY_RESOURCE_ARN_FIELD, BY_STATE_FIELD, BY_CREATED_BEFORE_FIELD, BY_CREATED_AFTER_FIELD, BY_RESOURCE_TYPE_FIELD, BY_DESTINATION_VAULT_ARN_FIELD, BY_ACCOUNT_ID_FIELD, BY_COMPLETE_BEFORE_FIELD, BY_COMPLETE_AFTER_FIELD, BY_PARENT_JOB_ID_FIELD, BY_MESSAGE_CATEGORY_FIELD, BY_SOURCE_RECOVERY_POINT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCopyJobsRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String byResourceArn;
    private final String byState;
    private final Instant byCreatedBefore;
    private final Instant byCreatedAfter;
    private final String byResourceType;
    private final String byDestinationVaultArn;
    private final String byAccountId;
    private final Instant byCompleteBefore;
    private final Instant byCompleteAfter;
    private final String byParentJobId;
    private final String byMessageCategory;
    private final String bySourceRecoveryPointArn;

    private ListCopyJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.byResourceArn = builder.byResourceArn;
        this.byState = builder.byState;
        this.byCreatedBefore = builder.byCreatedBefore;
        this.byCreatedAfter = builder.byCreatedAfter;
        this.byResourceType = builder.byResourceType;
        this.byDestinationVaultArn = builder.byDestinationVaultArn;
        this.byAccountId = builder.byAccountId;
        this.byCompleteBefore = builder.byCompleteBefore;
        this.byCompleteAfter = builder.byCompleteAfter;
        this.byParentJobId = builder.byParentJobId;
        this.byMessageCategory = builder.byMessageCategory;
        this.bySourceRecoveryPointArn = builder.bySourceRecoveryPointArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String byResourceArn() {
        return this.byResourceArn;
    }

    public final CopyJobState byState() {
        return CopyJobState.fromValue(this.byState);
    }

    public final String byStateAsString() {
        return this.byState;
    }

    public final Instant byCreatedBefore() {
        return this.byCreatedBefore;
    }

    public final Instant byCreatedAfter() {
        return this.byCreatedAfter;
    }

    public final String byResourceType() {
        return this.byResourceType;
    }

    public final String byDestinationVaultArn() {
        return this.byDestinationVaultArn;
    }

    public final String byAccountId() {
        return this.byAccountId;
    }

    public final Instant byCompleteBefore() {
        return this.byCompleteBefore;
    }

    public final Instant byCompleteAfter() {
        return this.byCompleteAfter;
    }

    public final String byParentJobId() {
        return this.byParentJobId;
    }

    public final String byMessageCategory() {
        return this.byMessageCategory;
    }

    public final String bySourceRecoveryPointArn() {
        return this.bySourceRecoveryPointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.byResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.byStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCreatedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCreatedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.byResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.byDestinationVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.byAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCompleteBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCompleteAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.byParentJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.byMessageCategory());
        hashCode = 31 * hashCode + Objects.hashCode(this.bySourceRecoveryPointArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCopyJobsRequest)) {
            return false;
        }
        ListCopyJobsRequest other = (ListCopyJobsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.byResourceArn(), other.byResourceArn()) && Objects.equals(this.byStateAsString(), other.byStateAsString()) && Objects.equals(this.byCreatedBefore(), other.byCreatedBefore()) && Objects.equals(this.byCreatedAfter(), other.byCreatedAfter()) && Objects.equals(this.byResourceType(), other.byResourceType()) && Objects.equals(this.byDestinationVaultArn(), other.byDestinationVaultArn()) && Objects.equals(this.byAccountId(), other.byAccountId()) && Objects.equals(this.byCompleteBefore(), other.byCompleteBefore()) && Objects.equals(this.byCompleteAfter(), other.byCompleteAfter()) && Objects.equals(this.byParentJobId(), other.byParentJobId()) && Objects.equals(this.byMessageCategory(), other.byMessageCategory()) && Objects.equals(this.bySourceRecoveryPointArn(), other.bySourceRecoveryPointArn());
    }

    public final String toString() {
        return ToString.builder((String)"ListCopyJobsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ByResourceArn", (Object)this.byResourceArn()).add("ByState", (Object)this.byStateAsString()).add("ByCreatedBefore", (Object)this.byCreatedBefore()).add("ByCreatedAfter", (Object)this.byCreatedAfter()).add("ByResourceType", (Object)this.byResourceType()).add("ByDestinationVaultArn", (Object)this.byDestinationVaultArn()).add("ByAccountId", (Object)this.byAccountId()).add("ByCompleteBefore", (Object)this.byCompleteBefore()).add("ByCompleteAfter", (Object)this.byCompleteAfter()).add("ByParentJobId", (Object)this.byParentJobId()).add("ByMessageCategory", (Object)this.byMessageCategory()).add("BySourceRecoveryPointArn", (Object)this.bySourceRecoveryPointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ByResourceArn": {
                return Optional.ofNullable(clazz.cast(this.byResourceArn()));
            }
            case "ByState": {
                return Optional.ofNullable(clazz.cast(this.byStateAsString()));
            }
            case "ByCreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.byCreatedBefore()));
            }
            case "ByCreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.byCreatedAfter()));
            }
            case "ByResourceType": {
                return Optional.ofNullable(clazz.cast(this.byResourceType()));
            }
            case "ByDestinationVaultArn": {
                return Optional.ofNullable(clazz.cast(this.byDestinationVaultArn()));
            }
            case "ByAccountId": {
                return Optional.ofNullable(clazz.cast(this.byAccountId()));
            }
            case "ByCompleteBefore": {
                return Optional.ofNullable(clazz.cast(this.byCompleteBefore()));
            }
            case "ByCompleteAfter": {
                return Optional.ofNullable(clazz.cast(this.byCompleteAfter()));
            }
            case "ByParentJobId": {
                return Optional.ofNullable(clazz.cast(this.byParentJobId()));
            }
            case "ByMessageCategory": {
                return Optional.ofNullable(clazz.cast(this.byMessageCategory()));
            }
            case "BySourceRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.bySourceRecoveryPointArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("resourceArn", BY_RESOURCE_ARN_FIELD);
        map.put("state", BY_STATE_FIELD);
        map.put("createdBefore", BY_CREATED_BEFORE_FIELD);
        map.put("createdAfter", BY_CREATED_AFTER_FIELD);
        map.put("resourceType", BY_RESOURCE_TYPE_FIELD);
        map.put("destinationVaultArn", BY_DESTINATION_VAULT_ARN_FIELD);
        map.put("accountId", BY_ACCOUNT_ID_FIELD);
        map.put("completeBefore", BY_COMPLETE_BEFORE_FIELD);
        map.put("completeAfter", BY_COMPLETE_AFTER_FIELD);
        map.put("parentJobId", BY_PARENT_JOB_ID_FIELD);
        map.put("messageCategory", BY_MESSAGE_CATEGORY_FIELD);
        map.put("sourceRecoveryPointArn", BY_SOURCE_RECOVERY_POINT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCopyJobsRequest, T> g) {
        return obj -> g.apply((ListCopyJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String byResourceArn;
        private String byState;
        private Instant byCreatedBefore;
        private Instant byCreatedAfter;
        private String byResourceType;
        private String byDestinationVaultArn;
        private String byAccountId;
        private Instant byCompleteBefore;
        private Instant byCompleteAfter;
        private String byParentJobId;
        private String byMessageCategory;
        private String bySourceRecoveryPointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCopyJobsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.byResourceArn(model.byResourceArn);
            this.byState(model.byState);
            this.byCreatedBefore(model.byCreatedBefore);
            this.byCreatedAfter(model.byCreatedAfter);
            this.byResourceType(model.byResourceType);
            this.byDestinationVaultArn(model.byDestinationVaultArn);
            this.byAccountId(model.byAccountId);
            this.byCompleteBefore(model.byCompleteBefore);
            this.byCompleteAfter(model.byCompleteAfter);
            this.byParentJobId(model.byParentJobId);
            this.byMessageCategory(model.byMessageCategory);
            this.bySourceRecoveryPointArn(model.bySourceRecoveryPointArn);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getByResourceArn() {
            return this.byResourceArn;
        }

        public final void setByResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
        }

        @Override
        public final Builder byResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
            return this;
        }

        public final String getByState() {
            return this.byState;
        }

        public final void setByState(String byState) {
            this.byState = byState;
        }

        @Override
        public final Builder byState(String byState) {
            this.byState = byState;
            return this;
        }

        @Override
        public final Builder byState(CopyJobState byState) {
            this.byState(byState == null ? null : byState.toString());
            return this;
        }

        public final Instant getByCreatedBefore() {
            return this.byCreatedBefore;
        }

        public final void setByCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
        }

        @Override
        public final Builder byCreatedBefore(Instant byCreatedBefore) {
            this.byCreatedBefore = byCreatedBefore;
            return this;
        }

        public final Instant getByCreatedAfter() {
            return this.byCreatedAfter;
        }

        public final void setByCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
        }

        @Override
        public final Builder byCreatedAfter(Instant byCreatedAfter) {
            this.byCreatedAfter = byCreatedAfter;
            return this;
        }

        public final String getByResourceType() {
            return this.byResourceType;
        }

        public final void setByResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
        }

        @Override
        public final Builder byResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
            return this;
        }

        public final String getByDestinationVaultArn() {
            return this.byDestinationVaultArn;
        }

        public final void setByDestinationVaultArn(String byDestinationVaultArn) {
            this.byDestinationVaultArn = byDestinationVaultArn;
        }

        @Override
        public final Builder byDestinationVaultArn(String byDestinationVaultArn) {
            this.byDestinationVaultArn = byDestinationVaultArn;
            return this;
        }

        public final String getByAccountId() {
            return this.byAccountId;
        }

        public final void setByAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
        }

        @Override
        public final Builder byAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
            return this;
        }

        public final Instant getByCompleteBefore() {
            return this.byCompleteBefore;
        }

        public final void setByCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
        }

        @Override
        public final Builder byCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
            return this;
        }

        public final Instant getByCompleteAfter() {
            return this.byCompleteAfter;
        }

        public final void setByCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
        }

        @Override
        public final Builder byCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
            return this;
        }

        public final String getByParentJobId() {
            return this.byParentJobId;
        }

        public final void setByParentJobId(String byParentJobId) {
            this.byParentJobId = byParentJobId;
        }

        @Override
        public final Builder byParentJobId(String byParentJobId) {
            this.byParentJobId = byParentJobId;
            return this;
        }

        public final String getByMessageCategory() {
            return this.byMessageCategory;
        }

        public final void setByMessageCategory(String byMessageCategory) {
            this.byMessageCategory = byMessageCategory;
        }

        @Override
        public final Builder byMessageCategory(String byMessageCategory) {
            this.byMessageCategory = byMessageCategory;
            return this;
        }

        public final String getBySourceRecoveryPointArn() {
            return this.bySourceRecoveryPointArn;
        }

        public final void setBySourceRecoveryPointArn(String bySourceRecoveryPointArn) {
            this.bySourceRecoveryPointArn = bySourceRecoveryPointArn;
        }

        @Override
        public final Builder bySourceRecoveryPointArn(String bySourceRecoveryPointArn) {
            this.bySourceRecoveryPointArn = bySourceRecoveryPointArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCopyJobsRequest build() {
            return new ListCopyJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCopyJobsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder byResourceArn(String var1);

        public Builder byState(String var1);

        public Builder byState(CopyJobState var1);

        public Builder byCreatedBefore(Instant var1);

        public Builder byCreatedAfter(Instant var1);

        public Builder byResourceType(String var1);

        public Builder byDestinationVaultArn(String var1);

        public Builder byAccountId(String var1);

        public Builder byCompleteBefore(Instant var1);

        public Builder byCompleteAfter(Instant var1);

        public Builder byParentJobId(String var1);

        public Builder byMessageCategory(String var1);

        public Builder bySourceRecoveryPointArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

