/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.ReportDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportJob> {
    private static final SdkField<String> REPORT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportJobId").getter(ReportJob.getter(ReportJob::reportJobId)).setter(ReportJob.setter(Builder::reportJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportJobId").build()}).build();
    private static final SdkField<String> REPORT_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportPlanArn").getter(ReportJob.getter(ReportJob::reportPlanArn)).setter(ReportJob.setter(Builder::reportPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportPlanArn").build()}).build();
    private static final SdkField<String> REPORT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportTemplate").getter(ReportJob.getter(ReportJob::reportTemplate)).setter(ReportJob.setter(Builder::reportTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportTemplate").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ReportJob.getter(ReportJob::creationTime)).setter(ReportJob.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(ReportJob.getter(ReportJob::completionTime)).setter(ReportJob.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReportJob.getter(ReportJob::status)).setter(ReportJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ReportJob.getter(ReportJob::statusMessage)).setter(ReportJob.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<ReportDestination> REPORT_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportDestination").getter(ReportJob.getter(ReportJob::reportDestination)).setter(ReportJob.setter(Builder::reportDestination)).constructor(ReportDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_JOB_ID_FIELD, REPORT_PLAN_ARN_FIELD, REPORT_TEMPLATE_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, REPORT_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReportJob.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String reportJobId;
    private final String reportPlanArn;
    private final String reportTemplate;
    private final Instant creationTime;
    private final Instant completionTime;
    private final String status;
    private final String statusMessage;
    private final ReportDestination reportDestination;

    private ReportJob(BuilderImpl builder) {
        this.reportJobId = builder.reportJobId;
        this.reportPlanArn = builder.reportPlanArn;
        this.reportTemplate = builder.reportTemplate;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.reportDestination = builder.reportDestination;
    }

    public final String reportJobId() {
        return this.reportJobId;
    }

    public final String reportPlanArn() {
        return this.reportPlanArn;
    }

    public final String reportTemplate() {
        return this.reportTemplate;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final String status() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final ReportDestination reportDestination() {
        return this.reportDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reportJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportJob)) {
            return false;
        }
        ReportJob other = (ReportJob)obj;
        return Objects.equals(this.reportJobId(), other.reportJobId()) && Objects.equals(this.reportPlanArn(), other.reportPlanArn()) && Objects.equals(this.reportTemplate(), other.reportTemplate()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.reportDestination(), other.reportDestination());
    }

    public final String toString() {
        return ToString.builder((String)"ReportJob").add("ReportJobId", (Object)this.reportJobId()).add("ReportPlanArn", (Object)this.reportPlanArn()).add("ReportTemplate", (Object)this.reportTemplate()).add("CreationTime", (Object)this.creationTime()).add("CompletionTime", (Object)this.completionTime()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).add("ReportDestination", (Object)this.reportDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReportJobId": {
                return Optional.ofNullable(clazz.cast(this.reportJobId()));
            }
            case "ReportPlanArn": {
                return Optional.ofNullable(clazz.cast(this.reportPlanArn()));
            }
            case "ReportTemplate": {
                return Optional.ofNullable(clazz.cast(this.reportTemplate()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ReportDestination": {
                return Optional.ofNullable(clazz.cast(this.reportDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReportJobId", REPORT_JOB_ID_FIELD);
        map.put("ReportPlanArn", REPORT_PLAN_ARN_FIELD);
        map.put("ReportTemplate", REPORT_TEMPLATE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ReportDestination", REPORT_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReportJob, T> g) {
        return obj -> g.apply((ReportJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String reportJobId;
        private String reportPlanArn;
        private String reportTemplate;
        private Instant creationTime;
        private Instant completionTime;
        private String status;
        private String statusMessage;
        private ReportDestination reportDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportJob model) {
            this.reportJobId(model.reportJobId);
            this.reportPlanArn(model.reportPlanArn);
            this.reportTemplate(model.reportTemplate);
            this.creationTime(model.creationTime);
            this.completionTime(model.completionTime);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.reportDestination(model.reportDestination);
        }

        public final String getReportJobId() {
            return this.reportJobId;
        }

        public final void setReportJobId(String reportJobId) {
            this.reportJobId = reportJobId;
        }

        @Override
        public final Builder reportJobId(String reportJobId) {
            this.reportJobId = reportJobId;
            return this;
        }

        public final String getReportPlanArn() {
            return this.reportPlanArn;
        }

        public final void setReportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
        }

        @Override
        public final Builder reportPlanArn(String reportPlanArn) {
            this.reportPlanArn = reportPlanArn;
            return this;
        }

        public final String getReportTemplate() {
            return this.reportTemplate;
        }

        public final void setReportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
        }

        @Override
        public final Builder reportTemplate(String reportTemplate) {
            this.reportTemplate = reportTemplate;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final ReportDestination.Builder getReportDestination() {
            return this.reportDestination != null ? this.reportDestination.toBuilder() : null;
        }

        public final void setReportDestination(ReportDestination.BuilderImpl reportDestination) {
            this.reportDestination = reportDestination != null ? reportDestination.build() : null;
        }

        @Override
        public final Builder reportDestination(ReportDestination reportDestination) {
            this.reportDestination = reportDestination;
            return this;
        }

        public ReportJob build() {
            return new ReportJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportJob> {
        public Builder reportJobId(String var1);

        public Builder reportPlanArn(String var1);

        public Builder reportTemplate(String var1);

        public Builder creationTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder reportDestination(ReportDestination var1);

        default public Builder reportDestination(Consumer<ReportDestination.Builder> reportDestination) {
            return this.reportDestination((ReportDestination)((ReportDestination.Builder)ReportDestination.builder().applyMutation(reportDestination)).build());
        }
    }
}

