/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanMode {
    FULL_SCAN("FULL_SCAN"),
    INCREMENTAL_SCAN("INCREMENTAL_SCAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanMode> VALUE_MAP;
    private final String value;

    private ScanMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanMode> knownValues() {
        EnumSet<ScanMode> knownValues = EnumSet.allOf(ScanMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanMode.class, ScanMode::toString);
    }
}

