/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanResultStatus {
    NO_THREATS_FOUND("NO_THREATS_FOUND"),
    THREATS_FOUND("THREATS_FOUND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanResultStatus> VALUE_MAP;
    private final String value;

    private ScanResultStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanResultStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanResultStatus> knownValues() {
        EnumSet<ScanResultStatus> knownValues = EnumSet.allOf(ScanResultStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanResultStatus.class, ScanResultStatus::toString);
    }
}

