/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListTieringConfigurationsRequest;
import software.amazon.awssdk.services.backup.model.ListTieringConfigurationsResponse;
import software.amazon.awssdk.services.backup.model.TieringConfigurationsListMember;

public class ListTieringConfigurationsIterable
implements SdkIterable<ListTieringConfigurationsResponse> {
    private final BackupClient client;
    private final ListTieringConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTieringConfigurationsIterable(BackupClient client, ListTieringConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTieringConfigurationsResponseFetcher();
    }

    public Iterator<ListTieringConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TieringConfigurationsListMember> tieringConfigurations() {
        Function<ListTieringConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tieringConfigurations() != null) {
                return response.tieringConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTieringConfigurationsResponseFetcher
    implements SyncPageFetcher<ListTieringConfigurationsResponse> {
        private ListTieringConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTieringConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTieringConfigurationsResponse nextPage(ListTieringConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListTieringConfigurationsIterable.this.client.listTieringConfigurations(ListTieringConfigurationsIterable.this.firstRequest);
            }
            return ListTieringConfigurationsIterable.this.client.listTieringConfigurations((ListTieringConfigurationsRequest)((Object)ListTieringConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

