/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupsearch.model.BackupSearchResponse;
import software.amazon.awssdk.services.backupsearch.model.CurrentSearchProgress;
import software.amazon.awssdk.services.backupsearch.model.ItemFilters;
import software.amazon.awssdk.services.backupsearch.model.SearchJobState;
import software.amazon.awssdk.services.backupsearch.model.SearchScope;
import software.amazon.awssdk.services.backupsearch.model.SearchScopeSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSearchJobResponse
extends BackupSearchResponse
implements ToCopyableBuilder<Builder, GetSearchJobResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetSearchJobResponse.getter(GetSearchJobResponse::name)).setter(GetSearchJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<SearchScopeSummary> SEARCH_SCOPE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchScopeSummary").getter(GetSearchJobResponse.getter(GetSearchJobResponse::searchScopeSummary)).setter(GetSearchJobResponse.setter(Builder::searchScopeSummary)).constructor(SearchScopeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchScopeSummary").build()}).build();
    private static final SdkField<CurrentSearchProgress> CURRENT_SEARCH_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentSearchProgress").getter(GetSearchJobResponse.getter(GetSearchJobResponse::currentSearchProgress)).setter(GetSearchJobResponse.setter(Builder::currentSearchProgress)).constructor(CurrentSearchProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSearchProgress").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(GetSearchJobResponse.getter(GetSearchJobResponse::statusMessage)).setter(GetSearchJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(GetSearchJobResponse.getter(GetSearchJobResponse::encryptionKeyArn)).setter(GetSearchJobResponse.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(GetSearchJobResponse.getter(GetSearchJobResponse::completionTime)).setter(GetSearchJobResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetSearchJobResponse.getter(GetSearchJobResponse::statusAsString)).setter(GetSearchJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<SearchScope> SEARCH_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchScope").getter(GetSearchJobResponse.getter(GetSearchJobResponse::searchScope)).setter(GetSearchJobResponse.setter(Builder::searchScope)).constructor(SearchScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchScope").build()}).build();
    private static final SdkField<ItemFilters> ITEM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ItemFilters").getter(GetSearchJobResponse.getter(GetSearchJobResponse::itemFilters)).setter(GetSearchJobResponse.setter(Builder::itemFilters)).constructor(ItemFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemFilters").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GetSearchJobResponse.getter(GetSearchJobResponse::creationTime)).setter(GetSearchJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> SEARCH_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchJobIdentifier").getter(GetSearchJobResponse.getter(GetSearchJobResponse::searchJobIdentifier)).setter(GetSearchJobResponse.setter(Builder::searchJobIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobIdentifier").build()}).build();
    private static final SdkField<String> SEARCH_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchJobArn").getter(GetSearchJobResponse.getter(GetSearchJobResponse::searchJobArn)).setter(GetSearchJobResponse.setter(Builder::searchJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SEARCH_SCOPE_SUMMARY_FIELD, CURRENT_SEARCH_PROGRESS_FIELD, STATUS_MESSAGE_FIELD, ENCRYPTION_KEY_ARN_FIELD, COMPLETION_TIME_FIELD, STATUS_FIELD, SEARCH_SCOPE_FIELD, ITEM_FILTERS_FIELD, CREATION_TIME_FIELD, SEARCH_JOB_IDENTIFIER_FIELD, SEARCH_JOB_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSearchJobResponse.memberNameToFieldInitializer();
    private final String name;
    private final SearchScopeSummary searchScopeSummary;
    private final CurrentSearchProgress currentSearchProgress;
    private final String statusMessage;
    private final String encryptionKeyArn;
    private final Instant completionTime;
    private final String status;
    private final SearchScope searchScope;
    private final ItemFilters itemFilters;
    private final Instant creationTime;
    private final String searchJobIdentifier;
    private final String searchJobArn;

    private GetSearchJobResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.searchScopeSummary = builder.searchScopeSummary;
        this.currentSearchProgress = builder.currentSearchProgress;
        this.statusMessage = builder.statusMessage;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.completionTime = builder.completionTime;
        this.status = builder.status;
        this.searchScope = builder.searchScope;
        this.itemFilters = builder.itemFilters;
        this.creationTime = builder.creationTime;
        this.searchJobIdentifier = builder.searchJobIdentifier;
        this.searchJobArn = builder.searchJobArn;
    }

    public final String name() {
        return this.name;
    }

    public final SearchScopeSummary searchScopeSummary() {
        return this.searchScopeSummary;
    }

    public final CurrentSearchProgress currentSearchProgress() {
        return this.currentSearchProgress;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final SearchJobState status() {
        return SearchJobState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final SearchScope searchScope() {
        return this.searchScope;
    }

    public final ItemFilters itemFilters() {
        return this.itemFilters;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String searchJobIdentifier() {
        return this.searchJobIdentifier;
    }

    public final String searchJobArn() {
        return this.searchJobArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchScopeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentSearchProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchJobIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchJobArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSearchJobResponse)) {
            return false;
        }
        GetSearchJobResponse other = (GetSearchJobResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.searchScopeSummary(), other.searchScopeSummary()) && Objects.equals(this.currentSearchProgress(), other.currentSearchProgress()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.searchScope(), other.searchScope()) && Objects.equals(this.itemFilters(), other.itemFilters()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.searchJobIdentifier(), other.searchJobIdentifier()) && Objects.equals(this.searchJobArn(), other.searchJobArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetSearchJobResponse").add("Name", (Object)this.name()).add("SearchScopeSummary", (Object)this.searchScopeSummary()).add("CurrentSearchProgress", (Object)this.currentSearchProgress()).add("StatusMessage", (Object)this.statusMessage()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("CompletionTime", (Object)this.completionTime()).add("Status", (Object)this.statusAsString()).add("SearchScope", (Object)this.searchScope()).add("ItemFilters", (Object)this.itemFilters()).add("CreationTime", (Object)this.creationTime()).add("SearchJobIdentifier", (Object)this.searchJobIdentifier()).add("SearchJobArn", (Object)this.searchJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SearchScopeSummary": {
                return Optional.ofNullable(clazz.cast(this.searchScopeSummary()));
            }
            case "CurrentSearchProgress": {
                return Optional.ofNullable(clazz.cast(this.currentSearchProgress()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SearchScope": {
                return Optional.ofNullable(clazz.cast(this.searchScope()));
            }
            case "ItemFilters": {
                return Optional.ofNullable(clazz.cast(this.itemFilters()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "SearchJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.searchJobIdentifier()));
            }
            case "SearchJobArn": {
                return Optional.ofNullable(clazz.cast(this.searchJobArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("SearchScopeSummary", SEARCH_SCOPE_SUMMARY_FIELD);
        map.put("CurrentSearchProgress", CURRENT_SEARCH_PROGRESS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("CompletionTime", COMPLETION_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SearchScope", SEARCH_SCOPE_FIELD);
        map.put("ItemFilters", ITEM_FILTERS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("SearchJobIdentifier", SEARCH_JOB_IDENTIFIER_FIELD);
        map.put("SearchJobArn", SEARCH_JOB_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSearchJobResponse, T> g) {
        return obj -> g.apply((GetSearchJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupSearchResponse.BuilderImpl
    implements Builder {
        private String name;
        private SearchScopeSummary searchScopeSummary;
        private CurrentSearchProgress currentSearchProgress;
        private String statusMessage;
        private String encryptionKeyArn;
        private Instant completionTime;
        private String status;
        private SearchScope searchScope;
        private ItemFilters itemFilters;
        private Instant creationTime;
        private String searchJobIdentifier;
        private String searchJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSearchJobResponse model) {
            super(model);
            this.name(model.name);
            this.searchScopeSummary(model.searchScopeSummary);
            this.currentSearchProgress(model.currentSearchProgress);
            this.statusMessage(model.statusMessage);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.completionTime(model.completionTime);
            this.status(model.status);
            this.searchScope(model.searchScope);
            this.itemFilters(model.itemFilters);
            this.creationTime(model.creationTime);
            this.searchJobIdentifier(model.searchJobIdentifier);
            this.searchJobArn(model.searchJobArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SearchScopeSummary.Builder getSearchScopeSummary() {
            return this.searchScopeSummary != null ? this.searchScopeSummary.toBuilder() : null;
        }

        public final void setSearchScopeSummary(SearchScopeSummary.BuilderImpl searchScopeSummary) {
            this.searchScopeSummary = searchScopeSummary != null ? searchScopeSummary.build() : null;
        }

        @Override
        public final Builder searchScopeSummary(SearchScopeSummary searchScopeSummary) {
            this.searchScopeSummary = searchScopeSummary;
            return this;
        }

        public final CurrentSearchProgress.Builder getCurrentSearchProgress() {
            return this.currentSearchProgress != null ? this.currentSearchProgress.toBuilder() : null;
        }

        public final void setCurrentSearchProgress(CurrentSearchProgress.BuilderImpl currentSearchProgress) {
            this.currentSearchProgress = currentSearchProgress != null ? currentSearchProgress.build() : null;
        }

        @Override
        public final Builder currentSearchProgress(CurrentSearchProgress currentSearchProgress) {
            this.currentSearchProgress = currentSearchProgress;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SearchJobState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final SearchScope.Builder getSearchScope() {
            return this.searchScope != null ? this.searchScope.toBuilder() : null;
        }

        public final void setSearchScope(SearchScope.BuilderImpl searchScope) {
            this.searchScope = searchScope != null ? searchScope.build() : null;
        }

        @Override
        public final Builder searchScope(SearchScope searchScope) {
            this.searchScope = searchScope;
            return this;
        }

        public final ItemFilters.Builder getItemFilters() {
            return this.itemFilters != null ? this.itemFilters.toBuilder() : null;
        }

        public final void setItemFilters(ItemFilters.BuilderImpl itemFilters) {
            this.itemFilters = itemFilters != null ? itemFilters.build() : null;
        }

        @Override
        public final Builder itemFilters(ItemFilters itemFilters) {
            this.itemFilters = itemFilters;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getSearchJobIdentifier() {
            return this.searchJobIdentifier;
        }

        public final void setSearchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
        }

        @Override
        public final Builder searchJobIdentifier(String searchJobIdentifier) {
            this.searchJobIdentifier = searchJobIdentifier;
            return this;
        }

        public final String getSearchJobArn() {
            return this.searchJobArn;
        }

        public final void setSearchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
        }

        @Override
        public final Builder searchJobArn(String searchJobArn) {
            this.searchJobArn = searchJobArn;
            return this;
        }

        @Override
        public GetSearchJobResponse build() {
            return new GetSearchJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSearchJobResponse> {
        public Builder name(String var1);

        public Builder searchScopeSummary(SearchScopeSummary var1);

        default public Builder searchScopeSummary(Consumer<SearchScopeSummary.Builder> searchScopeSummary) {
            return this.searchScopeSummary((SearchScopeSummary)((SearchScopeSummary.Builder)SearchScopeSummary.builder().applyMutation(searchScopeSummary)).build());
        }

        public Builder currentSearchProgress(CurrentSearchProgress var1);

        default public Builder currentSearchProgress(Consumer<CurrentSearchProgress.Builder> currentSearchProgress) {
            return this.currentSearchProgress((CurrentSearchProgress)((CurrentSearchProgress.Builder)CurrentSearchProgress.builder().applyMutation(currentSearchProgress)).build());
        }

        public Builder statusMessage(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder completionTime(Instant var1);

        public Builder status(String var1);

        public Builder status(SearchJobState var1);

        public Builder searchScope(SearchScope var1);

        default public Builder searchScope(Consumer<SearchScope.Builder> searchScope) {
            return this.searchScope((SearchScope)((SearchScope.Builder)SearchScope.builder().applyMutation(searchScope)).build());
        }

        public Builder itemFilters(ItemFilters var1);

        default public Builder itemFilters(Consumer<ItemFilters.Builder> itemFilters) {
            return this.itemFilters((ItemFilters)((ItemFilters.Builder)ItemFilters.builder().applyMutation(itemFilters)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder searchJobIdentifier(String var1);

        public Builder searchJobArn(String var1);
    }
}

