/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupsearch.model.BackupSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSearchResultExportJobResponse
extends BackupSearchResponse
implements ToCopyableBuilder<Builder, StartSearchResultExportJobResponse> {
    private static final SdkField<String> EXPORT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportJobArn").getter(StartSearchResultExportJobResponse.getter(StartSearchResultExportJobResponse::exportJobArn)).setter(StartSearchResultExportJobResponse.setter(Builder::exportJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobArn").build()}).build();
    private static final SdkField<String> EXPORT_JOB_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportJobIdentifier").getter(StartSearchResultExportJobResponse.getter(StartSearchResultExportJobResponse::exportJobIdentifier)).setter(StartSearchResultExportJobResponse.setter(Builder::exportJobIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportJobIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_JOB_ARN_FIELD, EXPORT_JOB_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSearchResultExportJobResponse.memberNameToFieldInitializer();
    private final String exportJobArn;
    private final String exportJobIdentifier;

    private StartSearchResultExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.exportJobArn = builder.exportJobArn;
        this.exportJobIdentifier = builder.exportJobIdentifier;
    }

    public final String exportJobArn() {
        return this.exportJobArn;
    }

    public final String exportJobIdentifier() {
        return this.exportJobIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportJobIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSearchResultExportJobResponse)) {
            return false;
        }
        StartSearchResultExportJobResponse other = (StartSearchResultExportJobResponse)((Object)obj);
        return Objects.equals(this.exportJobArn(), other.exportJobArn()) && Objects.equals(this.exportJobIdentifier(), other.exportJobIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"StartSearchResultExportJobResponse").add("ExportJobArn", (Object)this.exportJobArn()).add("ExportJobIdentifier", (Object)this.exportJobIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExportJobArn": {
                return Optional.ofNullable(clazz.cast(this.exportJobArn()));
            }
            case "ExportJobIdentifier": {
                return Optional.ofNullable(clazz.cast(this.exportJobIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ExportJobArn", EXPORT_JOB_ARN_FIELD);
        map.put("ExportJobIdentifier", EXPORT_JOB_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSearchResultExportJobResponse, T> g) {
        return obj -> g.apply((StartSearchResultExportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupSearchResponse.BuilderImpl
    implements Builder {
        private String exportJobArn;
        private String exportJobIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSearchResultExportJobResponse model) {
            super(model);
            this.exportJobArn(model.exportJobArn);
            this.exportJobIdentifier(model.exportJobIdentifier);
        }

        public final String getExportJobArn() {
            return this.exportJobArn;
        }

        public final void setExportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
        }

        @Override
        public final Builder exportJobArn(String exportJobArn) {
            this.exportJobArn = exportJobArn;
            return this;
        }

        public final String getExportJobIdentifier() {
            return this.exportJobIdentifier;
        }

        public final void setExportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
        }

        @Override
        public final Builder exportJobIdentifier(String exportJobIdentifier) {
            this.exportJobIdentifier = exportJobIdentifier;
            return this;
        }

        @Override
        public StartSearchResultExportJobResponse build() {
            return new StartSearchResultExportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSearchResultExportJobResponse> {
        public Builder exportJobArn(String var1);

        public Builder exportJobIdentifier(String var1);
    }
}

