/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RestApiMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiGatewayToolOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiGatewayToolOverride> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ApiGatewayToolOverride.getter(ApiGatewayToolOverride::name)).setter(ApiGatewayToolOverride.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ApiGatewayToolOverride.getter(ApiGatewayToolOverride::description)).setter(ApiGatewayToolOverride.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(ApiGatewayToolOverride.getter(ApiGatewayToolOverride::path)).setter(ApiGatewayToolOverride.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("method").getter(ApiGatewayToolOverride.getter(ApiGatewayToolOverride::methodAsString)).setter(ApiGatewayToolOverride.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, PATH_FIELD, METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApiGatewayToolOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String path;
    private final String method;

    private ApiGatewayToolOverride(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.path = builder.path;
        this.method = builder.method;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String path() {
        return this.path;
    }

    public final RestApiMethod method() {
        return RestApiMethod.fromValue(this.method);
    }

    public final String methodAsString() {
        return this.method;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.methodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiGatewayToolOverride)) {
            return false;
        }
        ApiGatewayToolOverride other = (ApiGatewayToolOverride)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.path(), other.path()) && Objects.equals(this.methodAsString(), other.methodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApiGatewayToolOverride").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Path", (Object)this.path()).add("Method", (Object)this.methodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "method": {
                return Optional.ofNullable(clazz.cast(this.methodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("path", PATH_FIELD);
        map.put("method", METHOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiGatewayToolOverride, T> g) {
        return obj -> g.apply((ApiGatewayToolOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String path;
        private String method;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiGatewayToolOverride model) {
            this.name(model.name);
            this.description(model.description);
            this.path(model.path);
            this.method(model.method);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        public final Builder method(RestApiMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public ApiGatewayToolOverride build() {
            return new ApiGatewayToolOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiGatewayToolOverride> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder path(String var1);

        public Builder method(String var1);

        public Builder method(RestApiMethod var1);
    }
}

