/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MatchValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClaimMatchValueType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClaimMatchValueType> {
    private static final SdkField<String> MATCH_VALUE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchValueString").getter(ClaimMatchValueType.getter(ClaimMatchValueType::matchValueString)).setter(ClaimMatchValueType.setter(Builder::matchValueString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchValueString").build()}).build();
    private static final SdkField<List<String>> MATCH_VALUE_STRING_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("matchValueStringList").getter(ClaimMatchValueType.getter(ClaimMatchValueType::matchValueStringList)).setter(ClaimMatchValueType.setter(Builder::matchValueStringList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchValueStringList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_VALUE_STRING_FIELD, MATCH_VALUE_STRING_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClaimMatchValueType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String matchValueString;
    private final List<String> matchValueStringList;
    private final Type type;

    private ClaimMatchValueType(BuilderImpl builder) {
        this.matchValueString = builder.matchValueString;
        this.matchValueStringList = builder.matchValueStringList;
        this.type = builder.type;
    }

    public final String matchValueString() {
        return this.matchValueString;
    }

    public final boolean hasMatchValueStringList() {
        return this.matchValueStringList != null && !(this.matchValueStringList instanceof SdkAutoConstructList);
    }

    public final List<String> matchValueStringList() {
        return this.matchValueStringList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.matchValueString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchValueStringList() ? this.matchValueStringList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClaimMatchValueType)) {
            return false;
        }
        ClaimMatchValueType other = (ClaimMatchValueType)obj;
        return Objects.equals(this.matchValueString(), other.matchValueString()) && this.hasMatchValueStringList() == other.hasMatchValueStringList() && Objects.equals(this.matchValueStringList(), other.matchValueStringList());
    }

    public final String toString() {
        return ToString.builder((String)"ClaimMatchValueType").add("MatchValueString", (Object)this.matchValueString()).add("MatchValueStringList", this.hasMatchValueStringList() ? this.matchValueStringList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "matchValueString": {
                return Optional.ofNullable(clazz.cast(this.matchValueString()));
            }
            case "matchValueStringList": {
                return Optional.ofNullable(clazz.cast(this.matchValueStringList()));
            }
        }
        return Optional.empty();
    }

    public static ClaimMatchValueType fromMatchValueString(String matchValueString) {
        return (ClaimMatchValueType)ClaimMatchValueType.builder().matchValueString(matchValueString).build();
    }

    public static ClaimMatchValueType fromMatchValueStringList(List<String> matchValueStringList) {
        return (ClaimMatchValueType)ClaimMatchValueType.builder().matchValueStringList(matchValueStringList).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("matchValueString", MATCH_VALUE_STRING_FIELD);
        map.put("matchValueStringList", MATCH_VALUE_STRING_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClaimMatchValueType, T> g) {
        return obj -> g.apply((ClaimMatchValueType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        MATCH_VALUE_STRING,
        MATCH_VALUE_STRING_LIST,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String matchValueString;
        private List<String> matchValueStringList = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ClaimMatchValueType model) {
            this.matchValueString(model.matchValueString);
            this.matchValueStringList(model.matchValueStringList);
        }

        public final String getMatchValueString() {
            return this.matchValueString;
        }

        public final void setMatchValueString(String matchValueString) {
            String oldValue = this.matchValueString;
            this.matchValueString = matchValueString;
            this.handleUnionValueChange(Type.MATCH_VALUE_STRING, oldValue, this.matchValueString);
        }

        @Override
        public final Builder matchValueString(String matchValueString) {
            String oldValue = this.matchValueString;
            this.matchValueString = matchValueString;
            this.handleUnionValueChange(Type.MATCH_VALUE_STRING, oldValue, this.matchValueString);
            return this;
        }

        public final Collection<String> getMatchValueStringList() {
            if (this.matchValueStringList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchValueStringList;
        }

        public final void setMatchValueStringList(Collection<String> matchValueStringList) {
            List<String> oldValue = this.matchValueStringList;
            this.matchValueStringList = MatchValueStringListCopier.copy(matchValueStringList);
            this.handleUnionValueChange(Type.MATCH_VALUE_STRING_LIST, oldValue, this.matchValueStringList);
        }

        @Override
        public final Builder matchValueStringList(Collection<String> matchValueStringList) {
            List<String> oldValue = this.matchValueStringList;
            this.matchValueStringList = MatchValueStringListCopier.copy(matchValueStringList);
            this.handleUnionValueChange(Type.MATCH_VALUE_STRING_LIST, oldValue, this.matchValueStringList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchValueStringList(String ... matchValueStringList) {
            this.matchValueStringList(Arrays.asList(matchValueStringList));
            return this;
        }

        public ClaimMatchValueType build() {
            return new ClaimMatchValueType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClaimMatchValueType> {
        public Builder matchValueString(String var1);

        public Builder matchValueStringList(Collection<String> var1);

        public Builder matchValueStringList(String ... var1);
    }
}

