/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CodeInterpreterNetworkMode;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeInterpreterNetworkConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeInterpreterNetworkConfiguration> {
    private static final SdkField<String> NETWORK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkMode").getter(CodeInterpreterNetworkConfiguration.getter(CodeInterpreterNetworkConfiguration::networkModeAsString)).setter(CodeInterpreterNetworkConfiguration.setter(Builder::networkMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkMode").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(CodeInterpreterNetworkConfiguration.getter(CodeInterpreterNetworkConfiguration::vpcConfig)).setter(CodeInterpreterNetworkConfiguration.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_MODE_FIELD, VPC_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeInterpreterNetworkConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkMode;
    private final VpcConfig vpcConfig;

    private CodeInterpreterNetworkConfiguration(BuilderImpl builder) {
        this.networkMode = builder.networkMode;
        this.vpcConfig = builder.vpcConfig;
    }

    public final CodeInterpreterNetworkMode networkMode() {
        return CodeInterpreterNetworkMode.fromValue(this.networkMode);
    }

    public final String networkModeAsString() {
        return this.networkMode;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeInterpreterNetworkConfiguration)) {
            return false;
        }
        CodeInterpreterNetworkConfiguration other = (CodeInterpreterNetworkConfiguration)obj;
        return Objects.equals(this.networkModeAsString(), other.networkModeAsString()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CodeInterpreterNetworkConfiguration").add("NetworkMode", (Object)this.networkModeAsString()).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkMode": {
                return Optional.ofNullable(clazz.cast(this.networkModeAsString()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkMode", NETWORK_MODE_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeInterpreterNetworkConfiguration, T> g) {
        return obj -> g.apply((CodeInterpreterNetworkConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkMode;
        private VpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeInterpreterNetworkConfiguration model) {
            this.networkMode(model.networkMode);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getNetworkMode() {
            return this.networkMode;
        }

        public final void setNetworkMode(String networkMode) {
            this.networkMode = networkMode;
        }

        @Override
        public final Builder networkMode(String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        @Override
        public final Builder networkMode(CodeInterpreterNetworkMode networkMode) {
            this.networkMode(networkMode == null ? null : networkMode.toString());
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public CodeInterpreterNetworkConfiguration build() {
            return new CodeInterpreterNetworkConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeInterpreterNetworkConfiguration> {
        public Builder networkMode(String var1);

        public Builder networkMode(CodeInterpreterNetworkMode var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }
    }
}

