/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CodeInterpreterNetworkMode {
    PUBLIC("PUBLIC"),
    SANDBOX("SANDBOX"),
    VPC("VPC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CodeInterpreterNetworkMode> VALUE_MAP;
    private final String value;

    private CodeInterpreterNetworkMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CodeInterpreterNetworkMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CodeInterpreterNetworkMode> knownValues() {
        EnumSet<CodeInterpreterNetworkMode> knownValues = EnumSet.allOf(CodeInterpreterNetworkMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CodeInterpreterNetworkMode.class, CodeInterpreterNetworkMode::toString);
    }
}

