/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BrowserStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBrowserResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, CreateBrowserResponse> {
    private static final SdkField<String> BROWSER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserId").getter(CreateBrowserResponse.getter(CreateBrowserResponse::browserId)).setter(CreateBrowserResponse.setter(Builder::browserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserId").build()}).build();
    private static final SdkField<String> BROWSER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserArn").getter(CreateBrowserResponse.getter(CreateBrowserResponse::browserArn)).setter(CreateBrowserResponse.setter(Builder::browserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateBrowserResponse.getter(CreateBrowserResponse::createdAt)).setter(CreateBrowserResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateBrowserResponse.getter(CreateBrowserResponse::statusAsString)).setter(CreateBrowserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_ID_FIELD, BROWSER_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBrowserResponse.memberNameToFieldInitializer();
    private final String browserId;
    private final String browserArn;
    private final Instant createdAt;
    private final String status;

    private CreateBrowserResponse(BuilderImpl builder) {
        super(builder);
        this.browserId = builder.browserId;
        this.browserArn = builder.browserArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
    }

    public final String browserId() {
        return this.browserId;
    }

    public final String browserArn() {
        return this.browserArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final BrowserStatus status() {
        return BrowserStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.browserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBrowserResponse)) {
            return false;
        }
        CreateBrowserResponse other = (CreateBrowserResponse)((Object)obj);
        return Objects.equals(this.browserId(), other.browserId()) && Objects.equals(this.browserArn(), other.browserArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBrowserResponse").add("BrowserId", (Object)this.browserId()).add("BrowserArn", (Object)this.browserArn()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserId": {
                return Optional.ofNullable(clazz.cast(this.browserId()));
            }
            case "browserArn": {
                return Optional.ofNullable(clazz.cast(this.browserArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("browserId", BROWSER_ID_FIELD);
        map.put("browserArn", BROWSER_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBrowserResponse, T> g) {
        return obj -> g.apply((CreateBrowserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String browserId;
        private String browserArn;
        private Instant createdAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBrowserResponse model) {
            super(model);
            this.browserId(model.browserId);
            this.browserArn(model.browserArn);
            this.createdAt(model.createdAt);
            this.status(model.status);
        }

        public final String getBrowserId() {
            return this.browserId;
        }

        public final void setBrowserId(String browserId) {
            this.browserId = browserId;
        }

        @Override
        public final Builder browserId(String browserId) {
            this.browserId = browserId;
            return this;
        }

        public final String getBrowserArn() {
            return this.browserArn;
        }

        public final void setBrowserArn(String browserArn) {
            this.browserArn = browserArn;
        }

        @Override
        public final Builder browserArn(String browserArn) {
            this.browserArn = browserArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BrowserStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateBrowserResponse build() {
            return new CreateBrowserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBrowserResponse> {
        public Builder browserId(String var1);

        public Builder browserArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(BrowserStatus var1);
    }
}

