/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CodeInterpreterStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCodeInterpreterResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, CreateCodeInterpreterResponse> {
    private static final SdkField<String> CODE_INTERPRETER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeInterpreterId").getter(CreateCodeInterpreterResponse.getter(CreateCodeInterpreterResponse::codeInterpreterId)).setter(CreateCodeInterpreterResponse.setter(Builder::codeInterpreterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterId").build()}).build();
    private static final SdkField<String> CODE_INTERPRETER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeInterpreterArn").getter(CreateCodeInterpreterResponse.getter(CreateCodeInterpreterResponse::codeInterpreterArn)).setter(CreateCodeInterpreterResponse.setter(Builder::codeInterpreterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateCodeInterpreterResponse.getter(CreateCodeInterpreterResponse::createdAt)).setter(CreateCodeInterpreterResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateCodeInterpreterResponse.getter(CreateCodeInterpreterResponse::statusAsString)).setter(CreateCodeInterpreterResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_INTERPRETER_ID_FIELD, CODE_INTERPRETER_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCodeInterpreterResponse.memberNameToFieldInitializer();
    private final String codeInterpreterId;
    private final String codeInterpreterArn;
    private final Instant createdAt;
    private final String status;

    private CreateCodeInterpreterResponse(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterId = builder.codeInterpreterId;
        this.codeInterpreterArn = builder.codeInterpreterArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
    }

    public final String codeInterpreterId() {
        return this.codeInterpreterId;
    }

    public final String codeInterpreterArn() {
        return this.codeInterpreterArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final CodeInterpreterStatus status() {
        return CodeInterpreterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeInterpreterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeInterpreterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeInterpreterResponse)) {
            return false;
        }
        CreateCodeInterpreterResponse other = (CreateCodeInterpreterResponse)((Object)obj);
        return Objects.equals(this.codeInterpreterId(), other.codeInterpreterId()) && Objects.equals(this.codeInterpreterArn(), other.codeInterpreterArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCodeInterpreterResponse").add("CodeInterpreterId", (Object)this.codeInterpreterId()).add("CodeInterpreterArn", (Object)this.codeInterpreterArn()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeInterpreterId": {
                return Optional.ofNullable(clazz.cast(this.codeInterpreterId()));
            }
            case "codeInterpreterArn": {
                return Optional.ofNullable(clazz.cast(this.codeInterpreterArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codeInterpreterId", CODE_INTERPRETER_ID_FIELD);
        map.put("codeInterpreterArn", CODE_INTERPRETER_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeInterpreterResponse, T> g) {
        return obj -> g.apply((CreateCodeInterpreterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String codeInterpreterId;
        private String codeInterpreterArn;
        private Instant createdAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeInterpreterResponse model) {
            super(model);
            this.codeInterpreterId(model.codeInterpreterId);
            this.codeInterpreterArn(model.codeInterpreterArn);
            this.createdAt(model.createdAt);
            this.status(model.status);
        }

        public final String getCodeInterpreterId() {
            return this.codeInterpreterId;
        }

        public final void setCodeInterpreterId(String codeInterpreterId) {
            this.codeInterpreterId = codeInterpreterId;
        }

        @Override
        public final Builder codeInterpreterId(String codeInterpreterId) {
            this.codeInterpreterId = codeInterpreterId;
            return this;
        }

        public final String getCodeInterpreterArn() {
            return this.codeInterpreterArn;
        }

        public final void setCodeInterpreterArn(String codeInterpreterArn) {
            this.codeInterpreterArn = codeInterpreterArn;
        }

        @Override
        public final Builder codeInterpreterArn(String codeInterpreterArn) {
            this.codeInterpreterArn = codeInterpreterArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeInterpreterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateCodeInterpreterResponse build() {
            return new CreateCodeInterpreterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCodeInterpreterResponse> {
        public Builder codeInterpreterId(String var1);

        public Builder codeInterpreterArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(CodeInterpreterStatus var1);
    }
}

