/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DataSourceConfig;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorListCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorReference;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Rule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOnlineEvaluationConfigRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, CreateOnlineEvaluationConfigRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateOnlineEvaluationConfigRequest.getter(CreateOnlineEvaluationConfigRequest::clientToken)).setter(CreateOnlineEvaluationConfigRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigName").getter(CreateOnlineEvaluationConfigRequest.getter(CreateOnlineEvaluationConfigRequest::onlineEvaluationConfigName)).setter(CreateOnlineEvaluationConfigRequest.setter(Builder::onlineEvaluationConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateOnlineEvaluationConfigRequest.getter(CreateOnlineEvaluationConfigRequest::description)).setter(CreateOnlineEvaluationConfigRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Rule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rule").getter(CreateOnlineEvaluationConfigRequest.getter(CreateOnlineEvaluationConfigRequest::rule)).setter(CreateOnlineEvaluationConfigRequest.setter(Builder::rule)).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()}).build();
    private static final SdkField<DataSourceConfig> DATA_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSourceConfig").getter(CreateOnlineEvaluationConfigRequest.getter(CreateOnlineEvaluationConfigRequest::dataSourceConfig)).setter(CreateOnlineEvaluationConfigRequest.setter(Builder::dataSourceConfig)).constructor(DataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfig").build()}).build();
    private static final SdkField<List<EvaluatorReference>> EVALUATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluators").getter(CreateOnlineEvaluationConfigRequest.getter(CreateOnlineEvaluationConfigRequest::evaluators)).setter(CreateOnlineEvaluationConfigRequest.setter(Builder::evaluators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluatorReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATION_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationExecutionRoleArn").getter(CreateOnlineEvaluationConfigRequest.getter(CreateOnlineEvaluationConfigRequest::evaluationExecutionRoleArn)).setter(CreateOnlineEvaluationConfigRequest.setter(Builder::evaluationExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationExecutionRoleArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_ON_CREATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableOnCreate").getter(CreateOnlineEvaluationConfigRequest.getter(CreateOnlineEvaluationConfigRequest::enableOnCreate)).setter(CreateOnlineEvaluationConfigRequest.setter(Builder::enableOnCreate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableOnCreate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ONLINE_EVALUATION_CONFIG_NAME_FIELD, DESCRIPTION_FIELD, RULE_FIELD, DATA_SOURCE_CONFIG_FIELD, EVALUATORS_FIELD, EVALUATION_EXECUTION_ROLE_ARN_FIELD, ENABLE_ON_CREATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOnlineEvaluationConfigRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String onlineEvaluationConfigName;
    private final String description;
    private final Rule rule;
    private final DataSourceConfig dataSourceConfig;
    private final List<EvaluatorReference> evaluators;
    private final String evaluationExecutionRoleArn;
    private final Boolean enableOnCreate;

    private CreateOnlineEvaluationConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.onlineEvaluationConfigName = builder.onlineEvaluationConfigName;
        this.description = builder.description;
        this.rule = builder.rule;
        this.dataSourceConfig = builder.dataSourceConfig;
        this.evaluators = builder.evaluators;
        this.evaluationExecutionRoleArn = builder.evaluationExecutionRoleArn;
        this.enableOnCreate = builder.enableOnCreate;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String onlineEvaluationConfigName() {
        return this.onlineEvaluationConfigName;
    }

    public final String description() {
        return this.description;
    }

    public final Rule rule() {
        return this.rule;
    }

    public final DataSourceConfig dataSourceConfig() {
        return this.dataSourceConfig;
    }

    public final boolean hasEvaluators() {
        return this.evaluators != null && !(this.evaluators instanceof SdkAutoConstructList);
    }

    public final List<EvaluatorReference> evaluators() {
        return this.evaluators;
    }

    public final String evaluationExecutionRoleArn() {
        return this.evaluationExecutionRoleArn;
    }

    public final Boolean enableOnCreate() {
        return this.enableOnCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluators() ? this.evaluators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableOnCreate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOnlineEvaluationConfigRequest)) {
            return false;
        }
        CreateOnlineEvaluationConfigRequest other = (CreateOnlineEvaluationConfigRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.onlineEvaluationConfigName(), other.onlineEvaluationConfigName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.rule(), other.rule()) && Objects.equals(this.dataSourceConfig(), other.dataSourceConfig()) && this.hasEvaluators() == other.hasEvaluators() && Objects.equals(this.evaluators(), other.evaluators()) && Objects.equals(this.evaluationExecutionRoleArn(), other.evaluationExecutionRoleArn()) && Objects.equals(this.enableOnCreate(), other.enableOnCreate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOnlineEvaluationConfigRequest").add("ClientToken", (Object)this.clientToken()).add("OnlineEvaluationConfigName", (Object)this.onlineEvaluationConfigName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Rule", (Object)this.rule()).add("DataSourceConfig", (Object)this.dataSourceConfig()).add("Evaluators", this.hasEvaluators() ? this.evaluators() : null).add("EvaluationExecutionRoleArn", (Object)this.evaluationExecutionRoleArn()).add("EnableOnCreate", (Object)this.enableOnCreate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "onlineEvaluationConfigName": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "dataSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfig()));
            }
            case "evaluators": {
                return Optional.ofNullable(clazz.cast(this.evaluators()));
            }
            case "evaluationExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationExecutionRoleArn()));
            }
            case "enableOnCreate": {
                return Optional.ofNullable(clazz.cast(this.enableOnCreate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("onlineEvaluationConfigName", ONLINE_EVALUATION_CONFIG_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("rule", RULE_FIELD);
        map.put("dataSourceConfig", DATA_SOURCE_CONFIG_FIELD);
        map.put("evaluators", EVALUATORS_FIELD);
        map.put("evaluationExecutionRoleArn", EVALUATION_EXECUTION_ROLE_ARN_FIELD);
        map.put("enableOnCreate", ENABLE_ON_CREATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOnlineEvaluationConfigRequest, T> g) {
        return obj -> g.apply((CreateOnlineEvaluationConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String onlineEvaluationConfigName;
        private String description;
        private Rule rule;
        private DataSourceConfig dataSourceConfig;
        private List<EvaluatorReference> evaluators = DefaultSdkAutoConstructList.getInstance();
        private String evaluationExecutionRoleArn;
        private Boolean enableOnCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOnlineEvaluationConfigRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.onlineEvaluationConfigName(model.onlineEvaluationConfigName);
            this.description(model.description);
            this.rule(model.rule);
            this.dataSourceConfig(model.dataSourceConfig);
            this.evaluators(model.evaluators);
            this.evaluationExecutionRoleArn(model.evaluationExecutionRoleArn);
            this.enableOnCreate(model.enableOnCreate);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getOnlineEvaluationConfigName() {
            return this.onlineEvaluationConfigName;
        }

        public final void setOnlineEvaluationConfigName(String onlineEvaluationConfigName) {
            this.onlineEvaluationConfigName = onlineEvaluationConfigName;
        }

        @Override
        public final Builder onlineEvaluationConfigName(String onlineEvaluationConfigName) {
            this.onlineEvaluationConfigName = onlineEvaluationConfigName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Rule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(Rule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public final DataSourceConfig.Builder getDataSourceConfig() {
            return this.dataSourceConfig != null ? this.dataSourceConfig.toBuilder() : null;
        }

        public final void setDataSourceConfig(DataSourceConfig.BuilderImpl dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig != null ? dataSourceConfig.build() : null;
        }

        @Override
        public final Builder dataSourceConfig(DataSourceConfig dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig;
            return this;
        }

        public final List<EvaluatorReference.Builder> getEvaluators() {
            List<EvaluatorReference.Builder> result = EvaluatorListCopier.copyToBuilder(this.evaluators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluators(Collection<EvaluatorReference.BuilderImpl> evaluators) {
            this.evaluators = EvaluatorListCopier.copyFromBuilder(evaluators);
        }

        @Override
        public final Builder evaluators(Collection<EvaluatorReference> evaluators) {
            this.evaluators = EvaluatorListCopier.copy(evaluators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluators(EvaluatorReference ... evaluators) {
            this.evaluators(Arrays.asList(evaluators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluators(Consumer<EvaluatorReference.Builder> ... evaluators) {
            this.evaluators(Stream.of(evaluators).map(c -> (EvaluatorReference)((EvaluatorReference.Builder)EvaluatorReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEvaluationExecutionRoleArn() {
            return this.evaluationExecutionRoleArn;
        }

        public final void setEvaluationExecutionRoleArn(String evaluationExecutionRoleArn) {
            this.evaluationExecutionRoleArn = evaluationExecutionRoleArn;
        }

        @Override
        public final Builder evaluationExecutionRoleArn(String evaluationExecutionRoleArn) {
            this.evaluationExecutionRoleArn = evaluationExecutionRoleArn;
            return this;
        }

        public final Boolean getEnableOnCreate() {
            return this.enableOnCreate;
        }

        public final void setEnableOnCreate(Boolean enableOnCreate) {
            this.enableOnCreate = enableOnCreate;
        }

        @Override
        public final Builder enableOnCreate(Boolean enableOnCreate) {
            this.enableOnCreate = enableOnCreate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOnlineEvaluationConfigRequest build() {
            return new CreateOnlineEvaluationConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOnlineEvaluationConfigRequest> {
        public Builder clientToken(String var1);

        public Builder onlineEvaluationConfigName(String var1);

        public Builder description(String var1);

        public Builder rule(Rule var1);

        default public Builder rule(Consumer<Rule.Builder> rule) {
            return this.rule((Rule)((Rule.Builder)Rule.builder().applyMutation(rule)).build());
        }

        public Builder dataSourceConfig(DataSourceConfig var1);

        default public Builder dataSourceConfig(Consumer<DataSourceConfig.Builder> dataSourceConfig) {
            return this.dataSourceConfig((DataSourceConfig)((DataSourceConfig.Builder)DataSourceConfig.builder().applyMutation(dataSourceConfig)).build());
        }

        public Builder evaluators(Collection<EvaluatorReference> var1);

        public Builder evaluators(EvaluatorReference ... var1);

        public Builder evaluators(Consumer<EvaluatorReference.Builder> ... var1);

        public Builder evaluationExecutionRoleArn(String var1);

        public Builder enableOnCreate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

