/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EpisodicConsolidationOverride;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SemanticConsolidationOverride;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SummaryConsolidationOverride;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.UserPreferenceConsolidationOverride;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomConsolidationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomConsolidationConfiguration> {
    private static final SdkField<SemanticConsolidationOverride> SEMANTIC_CONSOLIDATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("semanticConsolidationOverride").getter(CustomConsolidationConfiguration.getter(CustomConsolidationConfiguration::semanticConsolidationOverride)).setter(CustomConsolidationConfiguration.setter(Builder::semanticConsolidationOverride)).constructor(SemanticConsolidationOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticConsolidationOverride").build()}).build();
    private static final SdkField<SummaryConsolidationOverride> SUMMARY_CONSOLIDATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("summaryConsolidationOverride").getter(CustomConsolidationConfiguration.getter(CustomConsolidationConfiguration::summaryConsolidationOverride)).setter(CustomConsolidationConfiguration.setter(Builder::summaryConsolidationOverride)).constructor(SummaryConsolidationOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaryConsolidationOverride").build()}).build();
    private static final SdkField<UserPreferenceConsolidationOverride> USER_PREFERENCE_CONSOLIDATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userPreferenceConsolidationOverride").getter(CustomConsolidationConfiguration.getter(CustomConsolidationConfiguration::userPreferenceConsolidationOverride)).setter(CustomConsolidationConfiguration.setter(Builder::userPreferenceConsolidationOverride)).constructor(UserPreferenceConsolidationOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPreferenceConsolidationOverride").build()}).build();
    private static final SdkField<EpisodicConsolidationOverride> EPISODIC_CONSOLIDATION_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("episodicConsolidationOverride").getter(CustomConsolidationConfiguration.getter(CustomConsolidationConfiguration::episodicConsolidationOverride)).setter(CustomConsolidationConfiguration.setter(Builder::episodicConsolidationOverride)).constructor(EpisodicConsolidationOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("episodicConsolidationOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEMANTIC_CONSOLIDATION_OVERRIDE_FIELD, SUMMARY_CONSOLIDATION_OVERRIDE_FIELD, USER_PREFERENCE_CONSOLIDATION_OVERRIDE_FIELD, EPISODIC_CONSOLIDATION_OVERRIDE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomConsolidationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SemanticConsolidationOverride semanticConsolidationOverride;
    private final SummaryConsolidationOverride summaryConsolidationOverride;
    private final UserPreferenceConsolidationOverride userPreferenceConsolidationOverride;
    private final EpisodicConsolidationOverride episodicConsolidationOverride;
    private final Type type;

    private CustomConsolidationConfiguration(BuilderImpl builder) {
        this.semanticConsolidationOverride = builder.semanticConsolidationOverride;
        this.summaryConsolidationOverride = builder.summaryConsolidationOverride;
        this.userPreferenceConsolidationOverride = builder.userPreferenceConsolidationOverride;
        this.episodicConsolidationOverride = builder.episodicConsolidationOverride;
        this.type = builder.type;
    }

    public final SemanticConsolidationOverride semanticConsolidationOverride() {
        return this.semanticConsolidationOverride;
    }

    public final SummaryConsolidationOverride summaryConsolidationOverride() {
        return this.summaryConsolidationOverride;
    }

    public final UserPreferenceConsolidationOverride userPreferenceConsolidationOverride() {
        return this.userPreferenceConsolidationOverride;
    }

    public final EpisodicConsolidationOverride episodicConsolidationOverride() {
        return this.episodicConsolidationOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticConsolidationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryConsolidationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPreferenceConsolidationOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.episodicConsolidationOverride());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomConsolidationConfiguration)) {
            return false;
        }
        CustomConsolidationConfiguration other = (CustomConsolidationConfiguration)obj;
        return Objects.equals(this.semanticConsolidationOverride(), other.semanticConsolidationOverride()) && Objects.equals(this.summaryConsolidationOverride(), other.summaryConsolidationOverride()) && Objects.equals(this.userPreferenceConsolidationOverride(), other.userPreferenceConsolidationOverride()) && Objects.equals(this.episodicConsolidationOverride(), other.episodicConsolidationOverride());
    }

    public final String toString() {
        return ToString.builder((String)"CustomConsolidationConfiguration").add("SemanticConsolidationOverride", (Object)this.semanticConsolidationOverride()).add("SummaryConsolidationOverride", (Object)this.summaryConsolidationOverride()).add("UserPreferenceConsolidationOverride", (Object)this.userPreferenceConsolidationOverride()).add("EpisodicConsolidationOverride", (Object)this.episodicConsolidationOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "semanticConsolidationOverride": {
                return Optional.ofNullable(clazz.cast(this.semanticConsolidationOverride()));
            }
            case "summaryConsolidationOverride": {
                return Optional.ofNullable(clazz.cast(this.summaryConsolidationOverride()));
            }
            case "userPreferenceConsolidationOverride": {
                return Optional.ofNullable(clazz.cast(this.userPreferenceConsolidationOverride()));
            }
            case "episodicConsolidationOverride": {
                return Optional.ofNullable(clazz.cast(this.episodicConsolidationOverride()));
            }
        }
        return Optional.empty();
    }

    public static CustomConsolidationConfiguration fromSemanticConsolidationOverride(SemanticConsolidationOverride semanticConsolidationOverride) {
        return (CustomConsolidationConfiguration)CustomConsolidationConfiguration.builder().semanticConsolidationOverride(semanticConsolidationOverride).build();
    }

    public static CustomConsolidationConfiguration fromSemanticConsolidationOverride(Consumer<SemanticConsolidationOverride.Builder> semanticConsolidationOverride) {
        SemanticConsolidationOverride.Builder builder = SemanticConsolidationOverride.builder();
        semanticConsolidationOverride.accept(builder);
        return CustomConsolidationConfiguration.fromSemanticConsolidationOverride((SemanticConsolidationOverride)builder.build());
    }

    public static CustomConsolidationConfiguration fromSummaryConsolidationOverride(SummaryConsolidationOverride summaryConsolidationOverride) {
        return (CustomConsolidationConfiguration)CustomConsolidationConfiguration.builder().summaryConsolidationOverride(summaryConsolidationOverride).build();
    }

    public static CustomConsolidationConfiguration fromSummaryConsolidationOverride(Consumer<SummaryConsolidationOverride.Builder> summaryConsolidationOverride) {
        SummaryConsolidationOverride.Builder builder = SummaryConsolidationOverride.builder();
        summaryConsolidationOverride.accept(builder);
        return CustomConsolidationConfiguration.fromSummaryConsolidationOverride((SummaryConsolidationOverride)builder.build());
    }

    public static CustomConsolidationConfiguration fromUserPreferenceConsolidationOverride(UserPreferenceConsolidationOverride userPreferenceConsolidationOverride) {
        return (CustomConsolidationConfiguration)CustomConsolidationConfiguration.builder().userPreferenceConsolidationOverride(userPreferenceConsolidationOverride).build();
    }

    public static CustomConsolidationConfiguration fromUserPreferenceConsolidationOverride(Consumer<UserPreferenceConsolidationOverride.Builder> userPreferenceConsolidationOverride) {
        UserPreferenceConsolidationOverride.Builder builder = UserPreferenceConsolidationOverride.builder();
        userPreferenceConsolidationOverride.accept(builder);
        return CustomConsolidationConfiguration.fromUserPreferenceConsolidationOverride((UserPreferenceConsolidationOverride)builder.build());
    }

    public static CustomConsolidationConfiguration fromEpisodicConsolidationOverride(EpisodicConsolidationOverride episodicConsolidationOverride) {
        return (CustomConsolidationConfiguration)CustomConsolidationConfiguration.builder().episodicConsolidationOverride(episodicConsolidationOverride).build();
    }

    public static CustomConsolidationConfiguration fromEpisodicConsolidationOverride(Consumer<EpisodicConsolidationOverride.Builder> episodicConsolidationOverride) {
        EpisodicConsolidationOverride.Builder builder = EpisodicConsolidationOverride.builder();
        episodicConsolidationOverride.accept(builder);
        return CustomConsolidationConfiguration.fromEpisodicConsolidationOverride((EpisodicConsolidationOverride)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("semanticConsolidationOverride", SEMANTIC_CONSOLIDATION_OVERRIDE_FIELD);
        map.put("summaryConsolidationOverride", SUMMARY_CONSOLIDATION_OVERRIDE_FIELD);
        map.put("userPreferenceConsolidationOverride", USER_PREFERENCE_CONSOLIDATION_OVERRIDE_FIELD);
        map.put("episodicConsolidationOverride", EPISODIC_CONSOLIDATION_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomConsolidationConfiguration, T> g) {
        return obj -> g.apply((CustomConsolidationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SEMANTIC_CONSOLIDATION_OVERRIDE,
        SUMMARY_CONSOLIDATION_OVERRIDE,
        USER_PREFERENCE_CONSOLIDATION_OVERRIDE,
        EPISODIC_CONSOLIDATION_OVERRIDE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SemanticConsolidationOverride semanticConsolidationOverride;
        private SummaryConsolidationOverride summaryConsolidationOverride;
        private UserPreferenceConsolidationOverride userPreferenceConsolidationOverride;
        private EpisodicConsolidationOverride episodicConsolidationOverride;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomConsolidationConfiguration model) {
            this.semanticConsolidationOverride(model.semanticConsolidationOverride);
            this.summaryConsolidationOverride(model.summaryConsolidationOverride);
            this.userPreferenceConsolidationOverride(model.userPreferenceConsolidationOverride);
            this.episodicConsolidationOverride(model.episodicConsolidationOverride);
        }

        public final SemanticConsolidationOverride.Builder getSemanticConsolidationOverride() {
            return this.semanticConsolidationOverride != null ? this.semanticConsolidationOverride.toBuilder() : null;
        }

        public final void setSemanticConsolidationOverride(SemanticConsolidationOverride.BuilderImpl semanticConsolidationOverride) {
            SemanticConsolidationOverride oldValue = this.semanticConsolidationOverride;
            this.semanticConsolidationOverride = semanticConsolidationOverride != null ? semanticConsolidationOverride.build() : null;
            this.handleUnionValueChange(Type.SEMANTIC_CONSOLIDATION_OVERRIDE, oldValue, this.semanticConsolidationOverride);
        }

        @Override
        public final Builder semanticConsolidationOverride(SemanticConsolidationOverride semanticConsolidationOverride) {
            SemanticConsolidationOverride oldValue = this.semanticConsolidationOverride;
            this.semanticConsolidationOverride = semanticConsolidationOverride;
            this.handleUnionValueChange(Type.SEMANTIC_CONSOLIDATION_OVERRIDE, oldValue, this.semanticConsolidationOverride);
            return this;
        }

        public final SummaryConsolidationOverride.Builder getSummaryConsolidationOverride() {
            return this.summaryConsolidationOverride != null ? this.summaryConsolidationOverride.toBuilder() : null;
        }

        public final void setSummaryConsolidationOverride(SummaryConsolidationOverride.BuilderImpl summaryConsolidationOverride) {
            SummaryConsolidationOverride oldValue = this.summaryConsolidationOverride;
            this.summaryConsolidationOverride = summaryConsolidationOverride != null ? summaryConsolidationOverride.build() : null;
            this.handleUnionValueChange(Type.SUMMARY_CONSOLIDATION_OVERRIDE, oldValue, this.summaryConsolidationOverride);
        }

        @Override
        public final Builder summaryConsolidationOverride(SummaryConsolidationOverride summaryConsolidationOverride) {
            SummaryConsolidationOverride oldValue = this.summaryConsolidationOverride;
            this.summaryConsolidationOverride = summaryConsolidationOverride;
            this.handleUnionValueChange(Type.SUMMARY_CONSOLIDATION_OVERRIDE, oldValue, this.summaryConsolidationOverride);
            return this;
        }

        public final UserPreferenceConsolidationOverride.Builder getUserPreferenceConsolidationOverride() {
            return this.userPreferenceConsolidationOverride != null ? this.userPreferenceConsolidationOverride.toBuilder() : null;
        }

        public final void setUserPreferenceConsolidationOverride(UserPreferenceConsolidationOverride.BuilderImpl userPreferenceConsolidationOverride) {
            UserPreferenceConsolidationOverride oldValue = this.userPreferenceConsolidationOverride;
            this.userPreferenceConsolidationOverride = userPreferenceConsolidationOverride != null ? userPreferenceConsolidationOverride.build() : null;
            this.handleUnionValueChange(Type.USER_PREFERENCE_CONSOLIDATION_OVERRIDE, oldValue, this.userPreferenceConsolidationOverride);
        }

        @Override
        public final Builder userPreferenceConsolidationOverride(UserPreferenceConsolidationOverride userPreferenceConsolidationOverride) {
            UserPreferenceConsolidationOverride oldValue = this.userPreferenceConsolidationOverride;
            this.userPreferenceConsolidationOverride = userPreferenceConsolidationOverride;
            this.handleUnionValueChange(Type.USER_PREFERENCE_CONSOLIDATION_OVERRIDE, oldValue, this.userPreferenceConsolidationOverride);
            return this;
        }

        public final EpisodicConsolidationOverride.Builder getEpisodicConsolidationOverride() {
            return this.episodicConsolidationOverride != null ? this.episodicConsolidationOverride.toBuilder() : null;
        }

        public final void setEpisodicConsolidationOverride(EpisodicConsolidationOverride.BuilderImpl episodicConsolidationOverride) {
            EpisodicConsolidationOverride oldValue = this.episodicConsolidationOverride;
            this.episodicConsolidationOverride = episodicConsolidationOverride != null ? episodicConsolidationOverride.build() : null;
            this.handleUnionValueChange(Type.EPISODIC_CONSOLIDATION_OVERRIDE, oldValue, this.episodicConsolidationOverride);
        }

        @Override
        public final Builder episodicConsolidationOverride(EpisodicConsolidationOverride episodicConsolidationOverride) {
            EpisodicConsolidationOverride oldValue = this.episodicConsolidationOverride;
            this.episodicConsolidationOverride = episodicConsolidationOverride;
            this.handleUnionValueChange(Type.EPISODIC_CONSOLIDATION_OVERRIDE, oldValue, this.episodicConsolidationOverride);
            return this;
        }

        public CustomConsolidationConfiguration build() {
            return new CustomConsolidationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomConsolidationConfiguration> {
        public Builder semanticConsolidationOverride(SemanticConsolidationOverride var1);

        default public Builder semanticConsolidationOverride(Consumer<SemanticConsolidationOverride.Builder> semanticConsolidationOverride) {
            return this.semanticConsolidationOverride((SemanticConsolidationOverride)((SemanticConsolidationOverride.Builder)SemanticConsolidationOverride.builder().applyMutation(semanticConsolidationOverride)).build());
        }

        public Builder summaryConsolidationOverride(SummaryConsolidationOverride var1);

        default public Builder summaryConsolidationOverride(Consumer<SummaryConsolidationOverride.Builder> summaryConsolidationOverride) {
            return this.summaryConsolidationOverride((SummaryConsolidationOverride)((SummaryConsolidationOverride.Builder)SummaryConsolidationOverride.builder().applyMutation(summaryConsolidationOverride)).build());
        }

        public Builder userPreferenceConsolidationOverride(UserPreferenceConsolidationOverride var1);

        default public Builder userPreferenceConsolidationOverride(Consumer<UserPreferenceConsolidationOverride.Builder> userPreferenceConsolidationOverride) {
            return this.userPreferenceConsolidationOverride((UserPreferenceConsolidationOverride)((UserPreferenceConsolidationOverride.Builder)UserPreferenceConsolidationOverride.builder().applyMutation(userPreferenceConsolidationOverride)).build());
        }

        public Builder episodicConsolidationOverride(EpisodicConsolidationOverride var1);

        default public Builder episodicConsolidationOverride(Consumer<EpisodicConsolidationOverride.Builder> episodicConsolidationOverride) {
            return this.episodicConsolidationOverride((EpisodicConsolidationOverride)((EpisodicConsolidationOverride.Builder)EpisodicConsolidationOverride.builder().applyMutation(episodicConsolidationOverride)).build());
        }
    }
}

