/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CodeInterpreterStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteCodeInterpreterResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, DeleteCodeInterpreterResponse> {
    private static final SdkField<String> CODE_INTERPRETER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("codeInterpreterId").getter(DeleteCodeInterpreterResponse.getter(DeleteCodeInterpreterResponse::codeInterpreterId)).setter(DeleteCodeInterpreterResponse.setter(Builder::codeInterpreterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteCodeInterpreterResponse.getter(DeleteCodeInterpreterResponse::statusAsString)).setter(DeleteCodeInterpreterResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(DeleteCodeInterpreterResponse.getter(DeleteCodeInterpreterResponse::lastUpdatedAt)).setter(DeleteCodeInterpreterResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_INTERPRETER_ID_FIELD, STATUS_FIELD, LAST_UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteCodeInterpreterResponse.memberNameToFieldInitializer();
    private final String codeInterpreterId;
    private final String status;
    private final Instant lastUpdatedAt;

    private DeleteCodeInterpreterResponse(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterId = builder.codeInterpreterId;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String codeInterpreterId() {
        return this.codeInterpreterId;
    }

    public final CodeInterpreterStatus status() {
        return CodeInterpreterStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.codeInterpreterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCodeInterpreterResponse)) {
            return false;
        }
        DeleteCodeInterpreterResponse other = (DeleteCodeInterpreterResponse)((Object)obj);
        return Objects.equals(this.codeInterpreterId(), other.codeInterpreterId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteCodeInterpreterResponse").add("CodeInterpreterId", (Object)this.codeInterpreterId()).add("Status", (Object)this.statusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "codeInterpreterId": {
                return Optional.ofNullable(clazz.cast(this.codeInterpreterId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codeInterpreterId", CODE_INTERPRETER_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteCodeInterpreterResponse, T> g) {
        return obj -> g.apply((DeleteCodeInterpreterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String codeInterpreterId;
        private String status;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCodeInterpreterResponse model) {
            super(model);
            this.codeInterpreterId(model.codeInterpreterId);
            this.status(model.status);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getCodeInterpreterId() {
            return this.codeInterpreterId;
        }

        public final void setCodeInterpreterId(String codeInterpreterId) {
            this.codeInterpreterId = codeInterpreterId;
        }

        @Override
        public final Builder codeInterpreterId(String codeInterpreterId) {
            this.codeInterpreterId = codeInterpreterId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeInterpreterStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public DeleteCodeInterpreterResponse build() {
            return new DeleteCodeInterpreterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteCodeInterpreterResponse> {
        public Builder codeInterpreterId(String var1);

        public Builder status(String var1);

        public Builder status(CodeInterpreterStatus var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

