/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteEvaluatorResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, DeleteEvaluatorResponse> {
    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluatorArn").getter(DeleteEvaluatorResponse.getter(DeleteEvaluatorResponse::evaluatorArn)).setter(DeleteEvaluatorResponse.setter(Builder::evaluatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorArn").build()}).build();
    private static final SdkField<String> EVALUATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluatorId").getter(DeleteEvaluatorResponse.getter(DeleteEvaluatorResponse::evaluatorId)).setter(DeleteEvaluatorResponse.setter(Builder::evaluatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteEvaluatorResponse.getter(DeleteEvaluatorResponse::statusAsString)).setter(DeleteEvaluatorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATOR_ARN_FIELD, EVALUATOR_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteEvaluatorResponse.memberNameToFieldInitializer();
    private final String evaluatorArn;
    private final String evaluatorId;
    private final String status;

    private DeleteEvaluatorResponse(BuilderImpl builder) {
        super(builder);
        this.evaluatorArn = builder.evaluatorArn;
        this.evaluatorId = builder.evaluatorId;
        this.status = builder.status;
    }

    public final String evaluatorArn() {
        return this.evaluatorArn;
    }

    public final String evaluatorId() {
        return this.evaluatorId;
    }

    public final EvaluatorStatus status() {
        return EvaluatorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEvaluatorResponse)) {
            return false;
        }
        DeleteEvaluatorResponse other = (DeleteEvaluatorResponse)((Object)obj);
        return Objects.equals(this.evaluatorArn(), other.evaluatorArn()) && Objects.equals(this.evaluatorId(), other.evaluatorId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteEvaluatorResponse").add("EvaluatorArn", (Object)this.evaluatorArn()).add("EvaluatorId", (Object)this.evaluatorId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evaluatorArn": {
                return Optional.ofNullable(clazz.cast(this.evaluatorArn()));
            }
            case "evaluatorId": {
                return Optional.ofNullable(clazz.cast(this.evaluatorId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("evaluatorArn", EVALUATOR_ARN_FIELD);
        map.put("evaluatorId", EVALUATOR_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteEvaluatorResponse, T> g) {
        return obj -> g.apply((DeleteEvaluatorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String evaluatorArn;
        private String evaluatorId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEvaluatorResponse model) {
            super(model);
            this.evaluatorArn(model.evaluatorArn);
            this.evaluatorId(model.evaluatorId);
            this.status(model.status);
        }

        public final String getEvaluatorArn() {
            return this.evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final String getEvaluatorId() {
            return this.evaluatorId;
        }

        public final void setEvaluatorId(String evaluatorId) {
            this.evaluatorId = evaluatorId;
        }

        @Override
        public final Builder evaluatorId(String evaluatorId) {
            this.evaluatorId = evaluatorId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluatorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DeleteEvaluatorResponse build() {
            return new DeleteEvaluatorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteEvaluatorResponse> {
        public Builder evaluatorArn(String var1);

        public Builder evaluatorId(String var1);

        public Builder status(String var1);

        public Builder status(EvaluatorStatus var1);
    }
}

