/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FilterValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(FilterValue.getter(FilterValue::stringValue)).setter(FilterValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("doubleValue").getter(FilterValue.getter(FilterValue::doubleValue)).setter(FilterValue.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("booleanValue").getter(FilterValue.getter(FilterValue::booleanValue)).setter(FilterValue.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD, DOUBLE_VALUE_FIELD, BOOLEAN_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FilterValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final Double doubleValue;
    private final Boolean booleanValue;
    private final Type type;

    private FilterValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.doubleValue = builder.doubleValue;
        this.booleanValue = builder.booleanValue;
        this.type = builder.type;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterValue)) {
            return false;
        }
        FilterValue other = (FilterValue)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.booleanValue(), other.booleanValue());
    }

    public final String toString() {
        return ToString.builder((String)"FilterValue").add("StringValue", (Object)this.stringValue()).add("DoubleValue", (Object)this.doubleValue()).add("BooleanValue", (Object)this.booleanValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "booleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
        }
        return Optional.empty();
    }

    public static FilterValue fromStringValue(String stringValue) {
        return (FilterValue)FilterValue.builder().stringValue(stringValue).build();
    }

    public static FilterValue fromDoubleValue(Double doubleValue) {
        return (FilterValue)FilterValue.builder().doubleValue(doubleValue).build();
    }

    public static FilterValue fromBooleanValue(Boolean booleanValue) {
        return (FilterValue)FilterValue.builder().booleanValue(booleanValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("doubleValue", DOUBLE_VALUE_FIELD);
        map.put("booleanValue", BOOLEAN_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterValue, T> g) {
        return obj -> g.apply((FilterValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STRING_VALUE,
        DOUBLE_VALUE,
        BOOLEAN_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private Double doubleValue;
        private Boolean booleanValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FilterValue model) {
            this.stringValue(model.stringValue);
            this.doubleValue(model.doubleValue);
            this.booleanValue(model.booleanValue);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public FilterValue build() {
            return new FilterValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FilterValue> {
        public Builder stringValue(String var1);

        public Builder doubleValue(Double var1);

        public Builder booleanValue(Boolean var1);
    }
}

