/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GatewayProtocolType {
    MCP("MCP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GatewayProtocolType> VALUE_MAP;
    private final String value;

    private GatewayProtocolType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GatewayProtocolType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GatewayProtocolType> knownValues() {
        EnumSet<GatewayProtocolType> knownValues = EnumSet.allOf(GatewayProtocolType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GatewayProtocolType.class, GatewayProtocolType::toString);
    }
}

