/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AuthorizerType;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GatewayProtocolType;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.GatewayStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GatewaySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GatewaySummary> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayId").getter(GatewaySummary.getter(GatewaySummary::gatewayId)).setter(GatewaySummary.setter(Builder::gatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GatewaySummary.getter(GatewaySummary::name)).setter(GatewaySummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GatewaySummary.getter(GatewaySummary::statusAsString)).setter(GatewaySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GatewaySummary.getter(GatewaySummary::description)).setter(GatewaySummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GatewaySummary.getter(GatewaySummary::createdAt)).setter(GatewaySummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GatewaySummary.getter(GatewaySummary::updatedAt)).setter(GatewaySummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> AUTHORIZER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizerType").getter(GatewaySummary.getter(GatewaySummary::authorizerTypeAsString)).setter(GatewaySummary.setter(Builder::authorizerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerType").build()}).build();
    private static final SdkField<String> PROTOCOL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocolType").getter(GatewaySummary.getter(GatewaySummary::protocolTypeAsString)).setter(GatewaySummary.setter(Builder::protocolType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD, NAME_FIELD, STATUS_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, AUTHORIZER_TYPE_FIELD, PROTOCOL_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GatewaySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String gatewayId;
    private final String name;
    private final String status;
    private final String description;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String authorizerType;
    private final String protocolType;

    private GatewaySummary(BuilderImpl builder) {
        this.gatewayId = builder.gatewayId;
        this.name = builder.name;
        this.status = builder.status;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.authorizerType = builder.authorizerType;
        this.protocolType = builder.protocolType;
    }

    public final String gatewayId() {
        return this.gatewayId;
    }

    public final String name() {
        return this.name;
    }

    public final GatewayStatus status() {
        return GatewayStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final AuthorizerType authorizerType() {
        return AuthorizerType.fromValue(this.authorizerType);
    }

    public final String authorizerTypeAsString() {
        return this.authorizerType;
    }

    public final GatewayProtocolType protocolType() {
        return GatewayProtocolType.fromValue(this.protocolType);
    }

    public final String protocolTypeAsString() {
        return this.protocolType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GatewaySummary)) {
            return false;
        }
        GatewaySummary other = (GatewaySummary)obj;
        return Objects.equals(this.gatewayId(), other.gatewayId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.authorizerTypeAsString(), other.authorizerTypeAsString()) && Objects.equals(this.protocolTypeAsString(), other.protocolTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GatewaySummary").add("GatewayId", (Object)this.gatewayId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("AuthorizerType", (Object)this.authorizerTypeAsString()).add("ProtocolType", (Object)this.protocolTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayId": {
                return Optional.ofNullable(clazz.cast(this.gatewayId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "authorizerType": {
                return Optional.ofNullable(clazz.cast(this.authorizerTypeAsString()));
            }
            case "protocolType": {
                return Optional.ofNullable(clazz.cast(this.protocolTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("authorizerType", AUTHORIZER_TYPE_FIELD);
        map.put("protocolType", PROTOCOL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GatewaySummary, T> g) {
        return obj -> g.apply((GatewaySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayId;
        private String name;
        private String status;
        private String description;
        private Instant createdAt;
        private Instant updatedAt;
        private String authorizerType;
        private String protocolType;

        private BuilderImpl() {
        }

        private BuilderImpl(GatewaySummary model) {
            this.gatewayId(model.gatewayId);
            this.name(model.name);
            this.status(model.status);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.authorizerType(model.authorizerType);
            this.protocolType(model.protocolType);
        }

        public final String getGatewayId() {
            return this.gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GatewayStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getAuthorizerType() {
            return this.authorizerType;
        }

        public final void setAuthorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
        }

        @Override
        public final Builder authorizerType(String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        @Override
        public final Builder authorizerType(AuthorizerType authorizerType) {
            this.authorizerType(authorizerType == null ? null : authorizerType.toString());
            return this;
        }

        public final String getProtocolType() {
            return this.protocolType;
        }

        public final void setProtocolType(String protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public final Builder protocolType(String protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        @Override
        public final Builder protocolType(GatewayProtocolType protocolType) {
            this.protocolType(protocolType == null ? null : protocolType.toString());
            return this;
        }

        public GatewaySummary build() {
            return new GatewaySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GatewaySummary> {
        public Builder gatewayId(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(GatewayStatus var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder authorizerType(String var1);

        public Builder authorizerType(AuthorizerType var1);

        public Builder protocolType(String var1);

        public Builder protocolType(GatewayProtocolType var1);
    }
}

