/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorConfig;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorLevel;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEvaluatorResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, GetEvaluatorResponse> {
    private static final SdkField<String> EVALUATOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluatorArn").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::evaluatorArn)).setter(GetEvaluatorResponse.setter(Builder::evaluatorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorArn").build()}).build();
    private static final SdkField<String> EVALUATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluatorId").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::evaluatorId)).setter(GetEvaluatorResponse.setter(Builder::evaluatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorId").build()}).build();
    private static final SdkField<String> EVALUATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluatorName").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::evaluatorName)).setter(GetEvaluatorResponse.setter(Builder::evaluatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::description)).setter(GetEvaluatorResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<EvaluatorConfig> EVALUATOR_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("evaluatorConfig").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::evaluatorConfig)).setter(GetEvaluatorResponse.setter(Builder::evaluatorConfig)).constructor(EvaluatorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorConfig").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("level").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::levelAsString)).setter(GetEvaluatorResponse.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::statusAsString)).setter(GetEvaluatorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::createdAt)).setter(GetEvaluatorResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::updatedAt)).setter(GetEvaluatorResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<Boolean> LOCKED_FOR_MODIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("lockedForModification").getter(GetEvaluatorResponse.getter(GetEvaluatorResponse::lockedForModification)).setter(GetEvaluatorResponse.setter(Builder::lockedForModification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lockedForModification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATOR_ARN_FIELD, EVALUATOR_ID_FIELD, EVALUATOR_NAME_FIELD, DESCRIPTION_FIELD, EVALUATOR_CONFIG_FIELD, LEVEL_FIELD, STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, LOCKED_FOR_MODIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEvaluatorResponse.memberNameToFieldInitializer();
    private final String evaluatorArn;
    private final String evaluatorId;
    private final String evaluatorName;
    private final String description;
    private final EvaluatorConfig evaluatorConfig;
    private final String level;
    private final String status;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Boolean lockedForModification;

    private GetEvaluatorResponse(BuilderImpl builder) {
        super(builder);
        this.evaluatorArn = builder.evaluatorArn;
        this.evaluatorId = builder.evaluatorId;
        this.evaluatorName = builder.evaluatorName;
        this.description = builder.description;
        this.evaluatorConfig = builder.evaluatorConfig;
        this.level = builder.level;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.lockedForModification = builder.lockedForModification;
    }

    public final String evaluatorArn() {
        return this.evaluatorArn;
    }

    public final String evaluatorId() {
        return this.evaluatorId;
    }

    public final String evaluatorName() {
        return this.evaluatorName;
    }

    public final String description() {
        return this.description;
    }

    public final EvaluatorConfig evaluatorConfig() {
        return this.evaluatorConfig;
    }

    public final EvaluatorLevel level() {
        return EvaluatorLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final EvaluatorStatus status() {
        return EvaluatorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Boolean lockedForModification() {
        return this.lockedForModification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lockedForModification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEvaluatorResponse)) {
            return false;
        }
        GetEvaluatorResponse other = (GetEvaluatorResponse)((Object)obj);
        return Objects.equals(this.evaluatorArn(), other.evaluatorArn()) && Objects.equals(this.evaluatorId(), other.evaluatorId()) && Objects.equals(this.evaluatorName(), other.evaluatorName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.evaluatorConfig(), other.evaluatorConfig()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.lockedForModification(), other.lockedForModification());
    }

    public final String toString() {
        return ToString.builder((String)"GetEvaluatorResponse").add("EvaluatorArn", (Object)this.evaluatorArn()).add("EvaluatorId", (Object)this.evaluatorId()).add("EvaluatorName", (Object)this.evaluatorName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EvaluatorConfig", (Object)this.evaluatorConfig()).add("Level", (Object)this.levelAsString()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("LockedForModification", (Object)this.lockedForModification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evaluatorArn": {
                return Optional.ofNullable(clazz.cast(this.evaluatorArn()));
            }
            case "evaluatorId": {
                return Optional.ofNullable(clazz.cast(this.evaluatorId()));
            }
            case "evaluatorName": {
                return Optional.ofNullable(clazz.cast(this.evaluatorName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "evaluatorConfig": {
                return Optional.ofNullable(clazz.cast(this.evaluatorConfig()));
            }
            case "level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "lockedForModification": {
                return Optional.ofNullable(clazz.cast(this.lockedForModification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("evaluatorArn", EVALUATOR_ARN_FIELD);
        map.put("evaluatorId", EVALUATOR_ID_FIELD);
        map.put("evaluatorName", EVALUATOR_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("evaluatorConfig", EVALUATOR_CONFIG_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("lockedForModification", LOCKED_FOR_MODIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEvaluatorResponse, T> g) {
        return obj -> g.apply((GetEvaluatorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String evaluatorArn;
        private String evaluatorId;
        private String evaluatorName;
        private String description;
        private EvaluatorConfig evaluatorConfig;
        private String level;
        private String status;
        private Instant createdAt;
        private Instant updatedAt;
        private Boolean lockedForModification;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEvaluatorResponse model) {
            super(model);
            this.evaluatorArn(model.evaluatorArn);
            this.evaluatorId(model.evaluatorId);
            this.evaluatorName(model.evaluatorName);
            this.description(model.description);
            this.evaluatorConfig(model.evaluatorConfig);
            this.level(model.level);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.lockedForModification(model.lockedForModification);
        }

        public final String getEvaluatorArn() {
            return this.evaluatorArn;
        }

        public final void setEvaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
        }

        @Override
        public final Builder evaluatorArn(String evaluatorArn) {
            this.evaluatorArn = evaluatorArn;
            return this;
        }

        public final String getEvaluatorId() {
            return this.evaluatorId;
        }

        public final void setEvaluatorId(String evaluatorId) {
            this.evaluatorId = evaluatorId;
        }

        @Override
        public final Builder evaluatorId(String evaluatorId) {
            this.evaluatorId = evaluatorId;
            return this;
        }

        public final String getEvaluatorName() {
            return this.evaluatorName;
        }

        public final void setEvaluatorName(String evaluatorName) {
            this.evaluatorName = evaluatorName;
        }

        @Override
        public final Builder evaluatorName(String evaluatorName) {
            this.evaluatorName = evaluatorName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EvaluatorConfig.Builder getEvaluatorConfig() {
            return this.evaluatorConfig != null ? this.evaluatorConfig.toBuilder() : null;
        }

        public final void setEvaluatorConfig(EvaluatorConfig.BuilderImpl evaluatorConfig) {
            this.evaluatorConfig = evaluatorConfig != null ? evaluatorConfig.build() : null;
        }

        @Override
        public final Builder evaluatorConfig(EvaluatorConfig evaluatorConfig) {
            this.evaluatorConfig = evaluatorConfig;
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(EvaluatorLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluatorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Boolean getLockedForModification() {
            return this.lockedForModification;
        }

        public final void setLockedForModification(Boolean lockedForModification) {
            this.lockedForModification = lockedForModification;
        }

        @Override
        public final Builder lockedForModification(Boolean lockedForModification) {
            this.lockedForModification = lockedForModification;
            return this;
        }

        @Override
        public GetEvaluatorResponse build() {
            return new GetEvaluatorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEvaluatorResponse> {
        public Builder evaluatorArn(String var1);

        public Builder evaluatorId(String var1);

        public Builder evaluatorName(String var1);

        public Builder description(String var1);

        public Builder evaluatorConfig(EvaluatorConfig var1);

        default public Builder evaluatorConfig(Consumer<EvaluatorConfig.Builder> evaluatorConfig) {
            return this.evaluatorConfig((EvaluatorConfig)((EvaluatorConfig.Builder)EvaluatorConfig.builder().applyMutation(evaluatorConfig)).build());
        }

        public Builder level(String var1);

        public Builder level(EvaluatorLevel var1);

        public Builder status(String var1);

        public Builder status(EvaluatorStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder lockedForModification(Boolean var1);
    }
}

