/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGatewayTargetRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, GetGatewayTargetRequest> {
    private static final SdkField<String> GATEWAY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("gatewayIdentifier").getter(GetGatewayTargetRequest.getter(GetGatewayTargetRequest::gatewayIdentifier)).setter(GetGatewayTargetRequest.setter(Builder::gatewayIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayIdentifier").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetId").getter(GetGatewayTargetRequest.getter(GetGatewayTargetRequest::targetId)).setter(GetGatewayTargetRequest.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("targetId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_IDENTIFIER_FIELD, TARGET_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetGatewayTargetRequest.memberNameToFieldInitializer();
    private final String gatewayIdentifier;
    private final String targetId;

    private GetGatewayTargetRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayIdentifier = builder.gatewayIdentifier;
        this.targetId = builder.targetId;
    }

    public final String gatewayIdentifier() {
        return this.gatewayIdentifier;
    }

    public final String targetId() {
        return this.targetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGatewayTargetRequest)) {
            return false;
        }
        GetGatewayTargetRequest other = (GetGatewayTargetRequest)((Object)obj);
        return Objects.equals(this.gatewayIdentifier(), other.gatewayIdentifier()) && Objects.equals(this.targetId(), other.targetId());
    }

    public final String toString() {
        return ToString.builder((String)"GetGatewayTargetRequest").add("GatewayIdentifier", (Object)this.gatewayIdentifier()).add("TargetId", (Object)this.targetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "gatewayIdentifier": {
                return Optional.ofNullable(clazz.cast(this.gatewayIdentifier()));
            }
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("gatewayIdentifier", GATEWAY_IDENTIFIER_FIELD);
        map.put("targetId", TARGET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGatewayTargetRequest, T> g) {
        return obj -> g.apply((GetGatewayTargetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String gatewayIdentifier;
        private String targetId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGatewayTargetRequest model) {
            super(model);
            this.gatewayIdentifier(model.gatewayIdentifier);
            this.targetId(model.targetId);
        }

        public final String getGatewayIdentifier() {
            return this.gatewayIdentifier;
        }

        public final void setGatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
        }

        @Override
        public final Builder gatewayIdentifier(String gatewayIdentifier) {
            this.gatewayIdentifier = gatewayIdentifier;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGatewayTargetRequest build() {
            return new GetGatewayTargetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGatewayTargetRequest> {
        public Builder gatewayIdentifier(String var1);

        public Builder targetId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

