/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.DataSourceConfig;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorListCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorReference;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationConfigStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationExecutionStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OutputConfig;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Rule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOnlineEvaluationConfigResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, GetOnlineEvaluationConfigResponse> {
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigArn").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::onlineEvaluationConfigArn)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::onlineEvaluationConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigArn").build()}).build();
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigId").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::onlineEvaluationConfigId)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::onlineEvaluationConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigId").build()}).build();
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigName").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::onlineEvaluationConfigName)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::onlineEvaluationConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::description)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Rule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rule").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::rule)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::rule)).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()}).build();
    private static final SdkField<DataSourceConfig> DATA_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSourceConfig").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::dataSourceConfig)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::dataSourceConfig)).constructor(DataSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfig").build()}).build();
    private static final SdkField<List<EvaluatorReference>> EVALUATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluators").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::evaluators)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::evaluators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluatorReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfig").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::outputConfig)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()}).build();
    private static final SdkField<String> EVALUATION_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationExecutionRoleArn").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::evaluationExecutionRoleArn)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::evaluationExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationExecutionRoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::statusAsString)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStatus").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::executionStatusAsString)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::createdAt)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::updatedAt)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(GetOnlineEvaluationConfigResponse.getter(GetOnlineEvaluationConfigResponse::failureReason)).setter(GetOnlineEvaluationConfigResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONLINE_EVALUATION_CONFIG_ARN_FIELD, ONLINE_EVALUATION_CONFIG_ID_FIELD, ONLINE_EVALUATION_CONFIG_NAME_FIELD, DESCRIPTION_FIELD, RULE_FIELD, DATA_SOURCE_CONFIG_FIELD, EVALUATORS_FIELD, OUTPUT_CONFIG_FIELD, EVALUATION_EXECUTION_ROLE_ARN_FIELD, STATUS_FIELD, EXECUTION_STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOnlineEvaluationConfigResponse.memberNameToFieldInitializer();
    private final String onlineEvaluationConfigArn;
    private final String onlineEvaluationConfigId;
    private final String onlineEvaluationConfigName;
    private final String description;
    private final Rule rule;
    private final DataSourceConfig dataSourceConfig;
    private final List<EvaluatorReference> evaluators;
    private final OutputConfig outputConfig;
    private final String evaluationExecutionRoleArn;
    private final String status;
    private final String executionStatus;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String failureReason;

    private GetOnlineEvaluationConfigResponse(BuilderImpl builder) {
        super(builder);
        this.onlineEvaluationConfigArn = builder.onlineEvaluationConfigArn;
        this.onlineEvaluationConfigId = builder.onlineEvaluationConfigId;
        this.onlineEvaluationConfigName = builder.onlineEvaluationConfigName;
        this.description = builder.description;
        this.rule = builder.rule;
        this.dataSourceConfig = builder.dataSourceConfig;
        this.evaluators = builder.evaluators;
        this.outputConfig = builder.outputConfig;
        this.evaluationExecutionRoleArn = builder.evaluationExecutionRoleArn;
        this.status = builder.status;
        this.executionStatus = builder.executionStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.failureReason = builder.failureReason;
    }

    public final String onlineEvaluationConfigArn() {
        return this.onlineEvaluationConfigArn;
    }

    public final String onlineEvaluationConfigId() {
        return this.onlineEvaluationConfigId;
    }

    public final String onlineEvaluationConfigName() {
        return this.onlineEvaluationConfigName;
    }

    public final String description() {
        return this.description;
    }

    public final Rule rule() {
        return this.rule;
    }

    public final DataSourceConfig dataSourceConfig() {
        return this.dataSourceConfig;
    }

    public final boolean hasEvaluators() {
        return this.evaluators != null && !(this.evaluators instanceof SdkAutoConstructList);
    }

    public final List<EvaluatorReference> evaluators() {
        return this.evaluators;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String evaluationExecutionRoleArn() {
        return this.evaluationExecutionRoleArn;
    }

    public final OnlineEvaluationConfigStatus status() {
        return OnlineEvaluationConfigStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final OnlineEvaluationExecutionStatus executionStatus() {
        return OnlineEvaluationExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluators() ? this.evaluators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOnlineEvaluationConfigResponse)) {
            return false;
        }
        GetOnlineEvaluationConfigResponse other = (GetOnlineEvaluationConfigResponse)((Object)obj);
        return Objects.equals(this.onlineEvaluationConfigArn(), other.onlineEvaluationConfigArn()) && Objects.equals(this.onlineEvaluationConfigId(), other.onlineEvaluationConfigId()) && Objects.equals(this.onlineEvaluationConfigName(), other.onlineEvaluationConfigName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.rule(), other.rule()) && Objects.equals(this.dataSourceConfig(), other.dataSourceConfig()) && this.hasEvaluators() == other.hasEvaluators() && Objects.equals(this.evaluators(), other.evaluators()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.evaluationExecutionRoleArn(), other.evaluationExecutionRoleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"GetOnlineEvaluationConfigResponse").add("OnlineEvaluationConfigArn", (Object)this.onlineEvaluationConfigArn()).add("OnlineEvaluationConfigId", (Object)this.onlineEvaluationConfigId()).add("OnlineEvaluationConfigName", (Object)this.onlineEvaluationConfigName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Rule", (Object)this.rule()).add("DataSourceConfig", (Object)this.dataSourceConfig()).add("Evaluators", this.hasEvaluators() ? this.evaluators() : null).add("OutputConfig", (Object)this.outputConfig()).add("EvaluationExecutionRoleArn", (Object)this.evaluationExecutionRoleArn()).add("Status", (Object)this.statusAsString()).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "onlineEvaluationConfigArn": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigArn()));
            }
            case "onlineEvaluationConfigId": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigId()));
            }
            case "onlineEvaluationConfigName": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "dataSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfig()));
            }
            case "evaluators": {
                return Optional.ofNullable(clazz.cast(this.evaluators()));
            }
            case "outputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "evaluationExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationExecutionRoleArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("onlineEvaluationConfigArn", ONLINE_EVALUATION_CONFIG_ARN_FIELD);
        map.put("onlineEvaluationConfigId", ONLINE_EVALUATION_CONFIG_ID_FIELD);
        map.put("onlineEvaluationConfigName", ONLINE_EVALUATION_CONFIG_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("rule", RULE_FIELD);
        map.put("dataSourceConfig", DATA_SOURCE_CONFIG_FIELD);
        map.put("evaluators", EVALUATORS_FIELD);
        map.put("outputConfig", OUTPUT_CONFIG_FIELD);
        map.put("evaluationExecutionRoleArn", EVALUATION_EXECUTION_ROLE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOnlineEvaluationConfigResponse, T> g) {
        return obj -> g.apply((GetOnlineEvaluationConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String onlineEvaluationConfigArn;
        private String onlineEvaluationConfigId;
        private String onlineEvaluationConfigName;
        private String description;
        private Rule rule;
        private DataSourceConfig dataSourceConfig;
        private List<EvaluatorReference> evaluators = DefaultSdkAutoConstructList.getInstance();
        private OutputConfig outputConfig;
        private String evaluationExecutionRoleArn;
        private String status;
        private String executionStatus;
        private Instant createdAt;
        private Instant updatedAt;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOnlineEvaluationConfigResponse model) {
            super(model);
            this.onlineEvaluationConfigArn(model.onlineEvaluationConfigArn);
            this.onlineEvaluationConfigId(model.onlineEvaluationConfigId);
            this.onlineEvaluationConfigName(model.onlineEvaluationConfigName);
            this.description(model.description);
            this.rule(model.rule);
            this.dataSourceConfig(model.dataSourceConfig);
            this.evaluators(model.evaluators);
            this.outputConfig(model.outputConfig);
            this.evaluationExecutionRoleArn(model.evaluationExecutionRoleArn);
            this.status(model.status);
            this.executionStatus(model.executionStatus);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.failureReason(model.failureReason);
        }

        public final String getOnlineEvaluationConfigArn() {
            return this.onlineEvaluationConfigArn;
        }

        public final void setOnlineEvaluationConfigArn(String onlineEvaluationConfigArn) {
            this.onlineEvaluationConfigArn = onlineEvaluationConfigArn;
        }

        @Override
        public final Builder onlineEvaluationConfigArn(String onlineEvaluationConfigArn) {
            this.onlineEvaluationConfigArn = onlineEvaluationConfigArn;
            return this;
        }

        public final String getOnlineEvaluationConfigId() {
            return this.onlineEvaluationConfigId;
        }

        public final void setOnlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
        }

        @Override
        public final Builder onlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
            return this;
        }

        public final String getOnlineEvaluationConfigName() {
            return this.onlineEvaluationConfigName;
        }

        public final void setOnlineEvaluationConfigName(String onlineEvaluationConfigName) {
            this.onlineEvaluationConfigName = onlineEvaluationConfigName;
        }

        @Override
        public final Builder onlineEvaluationConfigName(String onlineEvaluationConfigName) {
            this.onlineEvaluationConfigName = onlineEvaluationConfigName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Rule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(Rule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public final DataSourceConfig.Builder getDataSourceConfig() {
            return this.dataSourceConfig != null ? this.dataSourceConfig.toBuilder() : null;
        }

        public final void setDataSourceConfig(DataSourceConfig.BuilderImpl dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig != null ? dataSourceConfig.build() : null;
        }

        @Override
        public final Builder dataSourceConfig(DataSourceConfig dataSourceConfig) {
            this.dataSourceConfig = dataSourceConfig;
            return this;
        }

        public final List<EvaluatorReference.Builder> getEvaluators() {
            List<EvaluatorReference.Builder> result = EvaluatorListCopier.copyToBuilder(this.evaluators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluators(Collection<EvaluatorReference.BuilderImpl> evaluators) {
            this.evaluators = EvaluatorListCopier.copyFromBuilder(evaluators);
        }

        @Override
        public final Builder evaluators(Collection<EvaluatorReference> evaluators) {
            this.evaluators = EvaluatorListCopier.copy(evaluators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluators(EvaluatorReference ... evaluators) {
            this.evaluators(Arrays.asList(evaluators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluators(Consumer<EvaluatorReference.Builder> ... evaluators) {
            this.evaluators(Stream.of(evaluators).map(c -> (EvaluatorReference)((EvaluatorReference.Builder)EvaluatorReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getEvaluationExecutionRoleArn() {
            return this.evaluationExecutionRoleArn;
        }

        public final void setEvaluationExecutionRoleArn(String evaluationExecutionRoleArn) {
            this.evaluationExecutionRoleArn = evaluationExecutionRoleArn;
        }

        @Override
        public final Builder evaluationExecutionRoleArn(String evaluationExecutionRoleArn) {
            this.evaluationExecutionRoleArn = evaluationExecutionRoleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OnlineEvaluationConfigStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(OnlineEvaluationExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public GetOnlineEvaluationConfigResponse build() {
            return new GetOnlineEvaluationConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOnlineEvaluationConfigResponse> {
        public Builder onlineEvaluationConfigArn(String var1);

        public Builder onlineEvaluationConfigId(String var1);

        public Builder onlineEvaluationConfigName(String var1);

        public Builder description(String var1);

        public Builder rule(Rule var1);

        default public Builder rule(Consumer<Rule.Builder> rule) {
            return this.rule((Rule)((Rule.Builder)Rule.builder().applyMutation(rule)).build());
        }

        public Builder dataSourceConfig(DataSourceConfig var1);

        default public Builder dataSourceConfig(Consumer<DataSourceConfig.Builder> dataSourceConfig) {
            return this.dataSourceConfig((DataSourceConfig)((DataSourceConfig.Builder)DataSourceConfig.builder().applyMutation(dataSourceConfig)).build());
        }

        public Builder evaluators(Collection<EvaluatorReference> var1);

        public Builder evaluators(EvaluatorReference ... var1);

        public Builder evaluators(Consumer<EvaluatorReference.Builder> ... var1);

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder evaluationExecutionRoleArn(String var1);

        public Builder status(String var1);

        public Builder status(OnlineEvaluationConfigStatus var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(OnlineEvaluationExecutionStatus var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder failureReason(String var1);
    }
}

