/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyGenerationStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyStatusReasonsCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPolicyGenerationResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, GetPolicyGenerationResponse> {
    private static final SdkField<String> POLICY_ENGINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyEngineId").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::policyEngineId)).setter(GetPolicyGenerationResponse.setter(Builder::policyEngineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyEngineId").build()}).build();
    private static final SdkField<String> POLICY_GENERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyGenerationId").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::policyGenerationId)).setter(GetPolicyGenerationResponse.setter(Builder::policyGenerationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyGenerationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::name)).setter(GetPolicyGenerationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> POLICY_GENERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyGenerationArn").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::policyGenerationArn)).setter(GetPolicyGenerationResponse.setter(Builder::policyGenerationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyGenerationArn").build()}).build();
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resource").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::resource)).setter(GetPolicyGenerationResponse.setter(Builder::resource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::createdAt)).setter(GetPolicyGenerationResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::updatedAt)).setter(GetPolicyGenerationResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::statusAsString)).setter(GetPolicyGenerationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> STATUS_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusReasons").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::statusReasons)).setter(GetPolicyGenerationResponse.setter(Builder::statusReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findings").getter(GetPolicyGenerationResponse.getter(GetPolicyGenerationResponse::findings)).setter(GetPolicyGenerationResponse.setter(Builder::findings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ENGINE_ID_FIELD, POLICY_GENERATION_ID_FIELD, NAME_FIELD, POLICY_GENERATION_ARN_FIELD, RESOURCE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, STATUS_REASONS_FIELD, FINDINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPolicyGenerationResponse.memberNameToFieldInitializer();
    private final String policyEngineId;
    private final String policyGenerationId;
    private final String name;
    private final String policyGenerationArn;
    private final Resource resource;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String status;
    private final List<String> statusReasons;
    private final String findings;

    private GetPolicyGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.policyEngineId = builder.policyEngineId;
        this.policyGenerationId = builder.policyGenerationId;
        this.name = builder.name;
        this.policyGenerationArn = builder.policyGenerationArn;
        this.resource = builder.resource;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.statusReasons = builder.statusReasons;
        this.findings = builder.findings;
    }

    public final String policyEngineId() {
        return this.policyEngineId;
    }

    public final String policyGenerationId() {
        return this.policyGenerationId;
    }

    public final String name() {
        return this.name;
    }

    public final String policyGenerationArn() {
        return this.policyGenerationArn;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final PolicyGenerationStatus status() {
        return PolicyGenerationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasStatusReasons() {
        return this.statusReasons != null && !(this.statusReasons instanceof SdkAutoConstructList);
    }

    public final List<String> statusReasons() {
        return this.statusReasons;
    }

    public final String findings() {
        return this.findings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyEngineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyGenerationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyGenerationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusReasons() ? this.statusReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.findings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyGenerationResponse)) {
            return false;
        }
        GetPolicyGenerationResponse other = (GetPolicyGenerationResponse)((Object)obj);
        return Objects.equals(this.policyEngineId(), other.policyEngineId()) && Objects.equals(this.policyGenerationId(), other.policyGenerationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.policyGenerationArn(), other.policyGenerationArn()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasStatusReasons() == other.hasStatusReasons() && Objects.equals(this.statusReasons(), other.statusReasons()) && Objects.equals(this.findings(), other.findings());
    }

    public final String toString() {
        return ToString.builder((String)"GetPolicyGenerationResponse").add("PolicyEngineId", (Object)this.policyEngineId()).add("PolicyGenerationId", (Object)this.policyGenerationId()).add("Name", (Object)this.name()).add("PolicyGenerationArn", (Object)this.policyGenerationArn()).add("Resource", (Object)this.resource()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Status", (Object)this.statusAsString()).add("StatusReasons", this.hasStatusReasons() ? this.statusReasons() : null).add("Findings", (Object)this.findings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyEngineId": {
                return Optional.ofNullable(clazz.cast(this.policyEngineId()));
            }
            case "policyGenerationId": {
                return Optional.ofNullable(clazz.cast(this.policyGenerationId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "policyGenerationArn": {
                return Optional.ofNullable(clazz.cast(this.policyGenerationArn()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReasons": {
                return Optional.ofNullable(clazz.cast(this.statusReasons()));
            }
            case "findings": {
                return Optional.ofNullable(clazz.cast(this.findings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyEngineId", POLICY_ENGINE_ID_FIELD);
        map.put("policyGenerationId", POLICY_GENERATION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("policyGenerationArn", POLICY_GENERATION_ARN_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReasons", STATUS_REASONS_FIELD);
        map.put("findings", FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyGenerationResponse, T> g) {
        return obj -> g.apply((GetPolicyGenerationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String policyEngineId;
        private String policyGenerationId;
        private String name;
        private String policyGenerationArn;
        private Resource resource;
        private Instant createdAt;
        private Instant updatedAt;
        private String status;
        private List<String> statusReasons = DefaultSdkAutoConstructList.getInstance();
        private String findings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyGenerationResponse model) {
            super(model);
            this.policyEngineId(model.policyEngineId);
            this.policyGenerationId(model.policyGenerationId);
            this.name(model.name);
            this.policyGenerationArn(model.policyGenerationArn);
            this.resource(model.resource);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.status(model.status);
            this.statusReasons(model.statusReasons);
            this.findings(model.findings);
        }

        public final String getPolicyEngineId() {
            return this.policyEngineId;
        }

        public final void setPolicyEngineId(String policyEngineId) {
            this.policyEngineId = policyEngineId;
        }

        @Override
        public final Builder policyEngineId(String policyEngineId) {
            this.policyEngineId = policyEngineId;
            return this;
        }

        public final String getPolicyGenerationId() {
            return this.policyGenerationId;
        }

        public final void setPolicyGenerationId(String policyGenerationId) {
            this.policyGenerationId = policyGenerationId;
        }

        @Override
        public final Builder policyGenerationId(String policyGenerationId) {
            this.policyGenerationId = policyGenerationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPolicyGenerationArn() {
            return this.policyGenerationArn;
        }

        public final void setPolicyGenerationArn(String policyGenerationArn) {
            this.policyGenerationArn = policyGenerationArn;
        }

        @Override
        public final Builder policyGenerationArn(String policyGenerationArn) {
            this.policyGenerationArn = policyGenerationArn;
            return this;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PolicyGenerationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getStatusReasons() {
            if (this.statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusReasons;
        }

        public final void setStatusReasons(Collection<String> statusReasons) {
            this.statusReasons = PolicyStatusReasonsCopier.copy(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<String> statusReasons) {
            this.statusReasons = PolicyStatusReasonsCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(String ... statusReasons) {
            this.statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        public final String getFindings() {
            return this.findings;
        }

        public final void setFindings(String findings) {
            this.findings = findings;
        }

        @Override
        public final Builder findings(String findings) {
            this.findings = findings;
            return this;
        }

        @Override
        public GetPolicyGenerationResponse build() {
            return new GetPolicyGenerationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPolicyGenerationResponse> {
        public Builder policyEngineId(String var1);

        public Builder policyGenerationId(String var1);

        public Builder name(String var1);

        public Builder policyGenerationArn(String var1);

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().applyMutation(resource)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(PolicyGenerationStatus var1);

        public Builder statusReasons(Collection<String> var1);

        public Builder statusReasons(String ... var1);

        public Builder findings(String var1);
    }
}

