/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IncludedOauth2ProviderConfigInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IncludedOauth2ProviderConfigInput> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientId").getter(IncludedOauth2ProviderConfigInput.getter(IncludedOauth2ProviderConfigInput::clientId)).setter(IncludedOauth2ProviderConfigInput.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientSecret").getter(IncludedOauth2ProviderConfigInput.getter(IncludedOauth2ProviderConfigInput::clientSecret)).setter(IncludedOauth2ProviderConfigInput.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(IncludedOauth2ProviderConfigInput.getter(IncludedOauth2ProviderConfigInput::issuer)).setter(IncludedOauth2ProviderConfigInput.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<String> AUTHORIZATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationEndpoint").getter(IncludedOauth2ProviderConfigInput.getter(IncludedOauth2ProviderConfigInput::authorizationEndpoint)).setter(IncludedOauth2ProviderConfigInput.setter(Builder::authorizationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationEndpoint").build()}).build();
    private static final SdkField<String> TOKEN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenEndpoint").getter(IncludedOauth2ProviderConfigInput.getter(IncludedOauth2ProviderConfigInput::tokenEndpoint)).setter(IncludedOauth2ProviderConfigInput.setter(Builder::tokenEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, ISSUER_FIELD, AUTHORIZATION_ENDPOINT_FIELD, TOKEN_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IncludedOauth2ProviderConfigInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clientId;
    private final String clientSecret;
    private final String issuer;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;

    private IncludedOauth2ProviderConfigInput(BuilderImpl builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.issuer = builder.issuer;
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final String clientSecret() {
        return this.clientSecret;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public final String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncludedOauth2ProviderConfigInput)) {
            return false;
        }
        IncludedOauth2ProviderConfigInput other = (IncludedOauth2ProviderConfigInput)obj;
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.authorizationEndpoint(), other.authorizationEndpoint()) && Objects.equals(this.tokenEndpoint(), other.tokenEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"IncludedOauth2ProviderConfigInput").add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)(this.clientSecret() == null ? null : "*** Sensitive Data Redacted ***")).add("Issuer", (Object)this.issuer()).add("AuthorizationEndpoint", (Object)this.authorizationEndpoint()).add("TokenEndpoint", (Object)this.tokenEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "clientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "authorizationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.authorizationEndpoint()));
            }
            case "tokenEndpoint": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("clientSecret", CLIENT_SECRET_FIELD);
        map.put("issuer", ISSUER_FIELD);
        map.put("authorizationEndpoint", AUTHORIZATION_ENDPOINT_FIELD);
        map.put("tokenEndpoint", TOKEN_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IncludedOauth2ProviderConfigInput, T> g) {
        return obj -> g.apply((IncludedOauth2ProviderConfigInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientId;
        private String clientSecret;
        private String issuer;
        private String authorizationEndpoint;
        private String tokenEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(IncludedOauth2ProviderConfigInput model) {
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.issuer(model.issuer);
            this.authorizationEndpoint(model.authorizationEndpoint);
            this.tokenEndpoint(model.tokenEndpoint);
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getAuthorizationEndpoint() {
            return this.authorizationEndpoint;
        }

        public final void setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
        }

        @Override
        public final Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public final String getTokenEndpoint() {
            return this.tokenEndpoint;
        }

        public final void setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
        }

        @Override
        public final Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public IncludedOauth2ProviderConfigInput build() {
            return new IncludedOauth2ProviderConfigInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IncludedOauth2ProviderConfigInput> {
        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder issuer(String var1);

        public Builder authorizationEndpoint(String var1);

        public Builder tokenEndpoint(String var1);
    }
}

