/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.LambdaInterceptorConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InterceptorConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InterceptorConfiguration> {
    private static final SdkField<LambdaInterceptorConfiguration> LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambda").getter(InterceptorConfiguration.getter(InterceptorConfiguration::lambda)).setter(InterceptorConfiguration.setter(Builder::lambda)).constructor(LambdaInterceptorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InterceptorConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LambdaInterceptorConfiguration lambda;
    private final Type type;

    private InterceptorConfiguration(BuilderImpl builder) {
        this.lambda = builder.lambda;
        this.type = builder.type;
    }

    public final LambdaInterceptorConfiguration lambda() {
        return this.lambda;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterceptorConfiguration)) {
            return false;
        }
        InterceptorConfiguration other = (InterceptorConfiguration)obj;
        return Objects.equals(this.lambda(), other.lambda());
    }

    public final String toString() {
        return ToString.builder((String)"InterceptorConfiguration").add("Lambda", (Object)this.lambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
        }
        return Optional.empty();
    }

    public static InterceptorConfiguration fromLambda(LambdaInterceptorConfiguration lambda) {
        return (InterceptorConfiguration)InterceptorConfiguration.builder().lambda(lambda).build();
    }

    public static InterceptorConfiguration fromLambda(Consumer<LambdaInterceptorConfiguration.Builder> lambda) {
        LambdaInterceptorConfiguration.Builder builder = LambdaInterceptorConfiguration.builder();
        lambda.accept(builder);
        return InterceptorConfiguration.fromLambda((LambdaInterceptorConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<LambdaInterceptorConfiguration>> map = new HashMap<String, SdkField<LambdaInterceptorConfiguration>>();
        map.put("lambda", LAMBDA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InterceptorConfiguration, T> g) {
        return obj -> g.apply((InterceptorConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        LAMBDA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private LambdaInterceptorConfiguration lambda;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(InterceptorConfiguration model) {
            this.lambda(model.lambda);
        }

        public final LambdaInterceptorConfiguration.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaInterceptorConfiguration.BuilderImpl lambda) {
            LambdaInterceptorConfiguration oldValue = this.lambda;
            this.lambda = lambda != null ? lambda.build() : null;
            this.handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
        }

        @Override
        public final Builder lambda(LambdaInterceptorConfiguration lambda) {
            LambdaInterceptorConfiguration oldValue = this.lambda;
            this.lambda = lambda;
            this.handleUnionValueChange(Type.LAMBDA, oldValue, this.lambda);
            return this;
        }

        public InterceptorConfiguration build() {
            return new InterceptorConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InterceptorConfiguration> {
        public Builder lambda(LambdaInterceptorConfiguration var1);

        default public Builder lambda(Consumer<LambdaInterceptorConfiguration.Builder> lambda) {
            return this.lambda((LambdaInterceptorConfiguration)((LambdaInterceptorConfiguration.Builder)LambdaInterceptorConfiguration.builder().applyMutation(lambda)).build());
        }
    }
}

