/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Oauth2CredentialProviderItem;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Oauth2CredentialProvidersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOauth2CredentialProvidersResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, ListOauth2CredentialProvidersResponse> {
    private static final SdkField<List<Oauth2CredentialProviderItem>> CREDENTIAL_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("credentialProviders").getter(ListOauth2CredentialProvidersResponse.getter(ListOauth2CredentialProvidersResponse::credentialProviders)).setter(ListOauth2CredentialProvidersResponse.setter(Builder::credentialProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Oauth2CredentialProviderItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOauth2CredentialProvidersResponse.getter(ListOauth2CredentialProvidersResponse::nextToken)).setter(ListOauth2CredentialProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_PROVIDERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOauth2CredentialProvidersResponse.memberNameToFieldInitializer();
    private final List<Oauth2CredentialProviderItem> credentialProviders;
    private final String nextToken;

    private ListOauth2CredentialProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.credentialProviders = builder.credentialProviders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCredentialProviders() {
        return this.credentialProviders != null && !(this.credentialProviders instanceof SdkAutoConstructList);
    }

    public final List<Oauth2CredentialProviderItem> credentialProviders() {
        return this.credentialProviders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentialProviders() ? this.credentialProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOauth2CredentialProvidersResponse)) {
            return false;
        }
        ListOauth2CredentialProvidersResponse other = (ListOauth2CredentialProvidersResponse)((Object)obj);
        return this.hasCredentialProviders() == other.hasCredentialProviders() && Objects.equals(this.credentialProviders(), other.credentialProviders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOauth2CredentialProvidersResponse").add("CredentialProviders", this.hasCredentialProviders() ? this.credentialProviders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "credentialProviders": {
                return Optional.ofNullable(clazz.cast(this.credentialProviders()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("credentialProviders", CREDENTIAL_PROVIDERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOauth2CredentialProvidersResponse, T> g) {
        return obj -> g.apply((ListOauth2CredentialProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private List<Oauth2CredentialProviderItem> credentialProviders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOauth2CredentialProvidersResponse model) {
            super(model);
            this.credentialProviders(model.credentialProviders);
            this.nextToken(model.nextToken);
        }

        public final List<Oauth2CredentialProviderItem.Builder> getCredentialProviders() {
            List<Oauth2CredentialProviderItem.Builder> result = Oauth2CredentialProvidersCopier.copyToBuilder(this.credentialProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialProviders(Collection<Oauth2CredentialProviderItem.BuilderImpl> credentialProviders) {
            this.credentialProviders = Oauth2CredentialProvidersCopier.copyFromBuilder(credentialProviders);
        }

        @Override
        public final Builder credentialProviders(Collection<Oauth2CredentialProviderItem> credentialProviders) {
            this.credentialProviders = Oauth2CredentialProvidersCopier.copy(credentialProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviders(Oauth2CredentialProviderItem ... credentialProviders) {
            this.credentialProviders(Arrays.asList(credentialProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviders(Consumer<Oauth2CredentialProviderItem.Builder> ... credentialProviders) {
            this.credentialProviders(Stream.of(credentialProviders).map(c -> (Oauth2CredentialProviderItem)((Oauth2CredentialProviderItem.Builder)Oauth2CredentialProviderItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListOauth2CredentialProvidersResponse build() {
            return new ListOauth2CredentialProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOauth2CredentialProvidersResponse> {
        public Builder credentialProviders(Collection<Oauth2CredentialProviderItem> var1);

        public Builder credentialProviders(Oauth2CredentialProviderItem ... var1);

        public Builder credentialProviders(Consumer<Oauth2CredentialProviderItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

