/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorModelConfig;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RatingScale;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LlmAsAJudgeEvaluatorConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LlmAsAJudgeEvaluatorConfig> {
    private static final SdkField<String> INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instructions").getter(LlmAsAJudgeEvaluatorConfig.getter(LlmAsAJudgeEvaluatorConfig::instructions)).setter(LlmAsAJudgeEvaluatorConfig.setter(Builder::instructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructions").build()}).build();
    private static final SdkField<RatingScale> RATING_SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ratingScale").getter(LlmAsAJudgeEvaluatorConfig.getter(LlmAsAJudgeEvaluatorConfig::ratingScale)).setter(LlmAsAJudgeEvaluatorConfig.setter(Builder::ratingScale)).constructor(RatingScale::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ratingScale").build()}).build();
    private static final SdkField<EvaluatorModelConfig> MODEL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelConfig").getter(LlmAsAJudgeEvaluatorConfig.getter(LlmAsAJudgeEvaluatorConfig::modelConfig)).setter(LlmAsAJudgeEvaluatorConfig.setter(Builder::modelConfig)).constructor(EvaluatorModelConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTRUCTIONS_FIELD, RATING_SCALE_FIELD, MODEL_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LlmAsAJudgeEvaluatorConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instructions;
    private final RatingScale ratingScale;
    private final EvaluatorModelConfig modelConfig;

    private LlmAsAJudgeEvaluatorConfig(BuilderImpl builder) {
        this.instructions = builder.instructions;
        this.ratingScale = builder.ratingScale;
        this.modelConfig = builder.modelConfig;
    }

    public final String instructions() {
        return this.instructions;
    }

    public final RatingScale ratingScale() {
        return this.ratingScale;
    }

    public final EvaluatorModelConfig modelConfig() {
        return this.modelConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instructions());
        hashCode = 31 * hashCode + Objects.hashCode(this.ratingScale());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LlmAsAJudgeEvaluatorConfig)) {
            return false;
        }
        LlmAsAJudgeEvaluatorConfig other = (LlmAsAJudgeEvaluatorConfig)obj;
        return Objects.equals(this.instructions(), other.instructions()) && Objects.equals(this.ratingScale(), other.ratingScale()) && Objects.equals(this.modelConfig(), other.modelConfig());
    }

    public final String toString() {
        return ToString.builder((String)"LlmAsAJudgeEvaluatorConfig").add("Instructions", (Object)(this.instructions() == null ? null : "*** Sensitive Data Redacted ***")).add("RatingScale", (Object)this.ratingScale()).add("ModelConfig", (Object)this.modelConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instructions": {
                return Optional.ofNullable(clazz.cast(this.instructions()));
            }
            case "ratingScale": {
                return Optional.ofNullable(clazz.cast(this.ratingScale()));
            }
            case "modelConfig": {
                return Optional.ofNullable(clazz.cast(this.modelConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instructions", INSTRUCTIONS_FIELD);
        map.put("ratingScale", RATING_SCALE_FIELD);
        map.put("modelConfig", MODEL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LlmAsAJudgeEvaluatorConfig, T> g) {
        return obj -> g.apply((LlmAsAJudgeEvaluatorConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instructions;
        private RatingScale ratingScale;
        private EvaluatorModelConfig modelConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LlmAsAJudgeEvaluatorConfig model) {
            this.instructions(model.instructions);
            this.ratingScale(model.ratingScale);
            this.modelConfig(model.modelConfig);
        }

        public final String getInstructions() {
            return this.instructions;
        }

        public final void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Override
        public final Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public final RatingScale.Builder getRatingScale() {
            return this.ratingScale != null ? this.ratingScale.toBuilder() : null;
        }

        public final void setRatingScale(RatingScale.BuilderImpl ratingScale) {
            this.ratingScale = ratingScale != null ? ratingScale.build() : null;
        }

        @Override
        public final Builder ratingScale(RatingScale ratingScale) {
            this.ratingScale = ratingScale;
            return this;
        }

        public final EvaluatorModelConfig.Builder getModelConfig() {
            return this.modelConfig != null ? this.modelConfig.toBuilder() : null;
        }

        public final void setModelConfig(EvaluatorModelConfig.BuilderImpl modelConfig) {
            this.modelConfig = modelConfig != null ? modelConfig.build() : null;
        }

        @Override
        public final Builder modelConfig(EvaluatorModelConfig modelConfig) {
            this.modelConfig = modelConfig;
            return this;
        }

        public LlmAsAJudgeEvaluatorConfig build() {
            return new LlmAsAJudgeEvaluatorConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LlmAsAJudgeEvaluatorConfig> {
        public Builder instructions(String var1);

        public Builder ratingScale(RatingScale var1);

        default public Builder ratingScale(Consumer<RatingScale.Builder> ratingScale) {
            return this.ratingScale((RatingScale)((RatingScale.Builder)RatingScale.builder().applyMutation(ratingScale)).build());
        }

        public Builder modelConfig(EvaluatorModelConfig var1);

        default public Builder modelConfig(Consumer<EvaluatorModelConfig.Builder> modelConfig) {
            return this.modelConfig((EvaluatorModelConfig)((EvaluatorModelConfig.Builder)EvaluatorModelConfig.builder().applyMutation(modelConfig)).build());
        }
    }
}

