/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ToolSchema;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class McpLambdaTargetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, McpLambdaTargetConfiguration> {
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaArn").getter(McpLambdaTargetConfiguration.getter(McpLambdaTargetConfiguration::lambdaArn)).setter(McpLambdaTargetConfiguration.setter(Builder::lambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaArn").build()}).build();
    private static final SdkField<ToolSchema> TOOL_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolSchema").getter(McpLambdaTargetConfiguration.getter(McpLambdaTargetConfiguration::toolSchema)).setter(McpLambdaTargetConfiguration.setter(Builder::toolSchema)).constructor(ToolSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolSchema").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_ARN_FIELD, TOOL_SCHEMA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = McpLambdaTargetConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String lambdaArn;
    private final ToolSchema toolSchema;

    private McpLambdaTargetConfiguration(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.toolSchema = builder.toolSchema;
    }

    public final String lambdaArn() {
        return this.lambdaArn;
    }

    public final ToolSchema toolSchema() {
        return this.toolSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolSchema());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof McpLambdaTargetConfiguration)) {
            return false;
        }
        McpLambdaTargetConfiguration other = (McpLambdaTargetConfiguration)obj;
        return Objects.equals(this.lambdaArn(), other.lambdaArn()) && Objects.equals(this.toolSchema(), other.toolSchema());
    }

    public final String toString() {
        return ToString.builder((String)"McpLambdaTargetConfiguration").add("LambdaArn", (Object)this.lambdaArn()).add("ToolSchema", (Object)this.toolSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lambdaArn": {
                return Optional.ofNullable(clazz.cast(this.lambdaArn()));
            }
            case "toolSchema": {
                return Optional.ofNullable(clazz.cast(this.toolSchema()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lambdaArn", LAMBDA_ARN_FIELD);
        map.put("toolSchema", TOOL_SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<McpLambdaTargetConfiguration, T> g) {
        return obj -> g.apply((McpLambdaTargetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lambdaArn;
        private ToolSchema toolSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(McpLambdaTargetConfiguration model) {
            this.lambdaArn(model.lambdaArn);
            this.toolSchema(model.toolSchema);
        }

        public final String getLambdaArn() {
            return this.lambdaArn;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final ToolSchema.Builder getToolSchema() {
            return this.toolSchema != null ? this.toolSchema.toBuilder() : null;
        }

        public final void setToolSchema(ToolSchema.BuilderImpl toolSchema) {
            this.toolSchema = toolSchema != null ? toolSchema.build() : null;
        }

        @Override
        public final Builder toolSchema(ToolSchema toolSchema) {
            this.toolSchema = toolSchema;
            return this;
        }

        public McpLambdaTargetConfiguration build() {
            return new McpLambdaTargetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, McpLambdaTargetConfiguration> {
        public Builder lambdaArn(String var1);

        public Builder toolSchema(ToolSchema var1);

        default public Builder toolSchema(Consumer<ToolSchema.Builder> toolSchema) {
            return this.toolSchema((ToolSchema)((ToolSchema.Builder)ToolSchema.builder().applyMutation(toolSchema)).build());
        }
    }
}

