/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MemoryStrategyType {
    SEMANTIC("SEMANTIC"),
    SUMMARIZATION("SUMMARIZATION"),
    USER_PREFERENCE("USER_PREFERENCE"),
    CUSTOM("CUSTOM"),
    EPISODIC("EPISODIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MemoryStrategyType> VALUE_MAP;
    private final String value;

    private MemoryStrategyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MemoryStrategyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MemoryStrategyType> knownValues() {
        EnumSet<MemoryStrategyType> knownValues = EnumSet.allOf(MemoryStrategyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MemoryStrategyType.class, MemoryStrategyType::toString);
    }
}

