/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyValidationMode {
    FAIL_ON_ANY_FINDINGS("FAIL_ON_ANY_FINDINGS"),
    IGNORE_ALL_FINDINGS("IGNORE_ALL_FINDINGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyValidationMode> VALUE_MAP;
    private final String value;

    private PolicyValidationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyValidationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyValidationMode> knownValues() {
        EnumSet<PolicyValidationMode> knownValues = EnumSet.allOf(PolicyValidationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyValidationMode.class, PolicyValidationMode::toString);
    }
}

