/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.MessageBasedTriggerInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TimeBasedTriggerInput;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.TokenBasedTriggerInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TriggerConditionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TriggerConditionInput> {
    private static final SdkField<MessageBasedTriggerInput> MESSAGE_BASED_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messageBasedTrigger").getter(TriggerConditionInput.getter(TriggerConditionInput::messageBasedTrigger)).setter(TriggerConditionInput.setter(Builder::messageBasedTrigger)).constructor(MessageBasedTriggerInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageBasedTrigger").build()}).build();
    private static final SdkField<TokenBasedTriggerInput> TOKEN_BASED_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tokenBasedTrigger").getter(TriggerConditionInput.getter(TriggerConditionInput::tokenBasedTrigger)).setter(TriggerConditionInput.setter(Builder::tokenBasedTrigger)).constructor(TokenBasedTriggerInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenBasedTrigger").build()}).build();
    private static final SdkField<TimeBasedTriggerInput> TIME_BASED_TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeBasedTrigger").getter(TriggerConditionInput.getter(TriggerConditionInput::timeBasedTrigger)).setter(TriggerConditionInput.setter(Builder::timeBasedTrigger)).constructor(TimeBasedTriggerInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeBasedTrigger").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_BASED_TRIGGER_FIELD, TOKEN_BASED_TRIGGER_FIELD, TIME_BASED_TRIGGER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TriggerConditionInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MessageBasedTriggerInput messageBasedTrigger;
    private final TokenBasedTriggerInput tokenBasedTrigger;
    private final TimeBasedTriggerInput timeBasedTrigger;
    private final Type type;

    private TriggerConditionInput(BuilderImpl builder) {
        this.messageBasedTrigger = builder.messageBasedTrigger;
        this.tokenBasedTrigger = builder.tokenBasedTrigger;
        this.timeBasedTrigger = builder.timeBasedTrigger;
        this.type = builder.type;
    }

    public final MessageBasedTriggerInput messageBasedTrigger() {
        return this.messageBasedTrigger;
    }

    public final TokenBasedTriggerInput tokenBasedTrigger() {
        return this.tokenBasedTrigger;
    }

    public final TimeBasedTriggerInput timeBasedTrigger() {
        return this.timeBasedTrigger;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageBasedTrigger());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenBasedTrigger());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeBasedTrigger());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerConditionInput)) {
            return false;
        }
        TriggerConditionInput other = (TriggerConditionInput)obj;
        return Objects.equals(this.messageBasedTrigger(), other.messageBasedTrigger()) && Objects.equals(this.tokenBasedTrigger(), other.tokenBasedTrigger()) && Objects.equals(this.timeBasedTrigger(), other.timeBasedTrigger());
    }

    public final String toString() {
        return ToString.builder((String)"TriggerConditionInput").add("MessageBasedTrigger", (Object)this.messageBasedTrigger()).add("TokenBasedTrigger", (Object)this.tokenBasedTrigger()).add("TimeBasedTrigger", (Object)this.timeBasedTrigger()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messageBasedTrigger": {
                return Optional.ofNullable(clazz.cast(this.messageBasedTrigger()));
            }
            case "tokenBasedTrigger": {
                return Optional.ofNullable(clazz.cast(this.tokenBasedTrigger()));
            }
            case "timeBasedTrigger": {
                return Optional.ofNullable(clazz.cast(this.timeBasedTrigger()));
            }
        }
        return Optional.empty();
    }

    public static TriggerConditionInput fromMessageBasedTrigger(MessageBasedTriggerInput messageBasedTrigger) {
        return (TriggerConditionInput)TriggerConditionInput.builder().messageBasedTrigger(messageBasedTrigger).build();
    }

    public static TriggerConditionInput fromMessageBasedTrigger(Consumer<MessageBasedTriggerInput.Builder> messageBasedTrigger) {
        MessageBasedTriggerInput.Builder builder = MessageBasedTriggerInput.builder();
        messageBasedTrigger.accept(builder);
        return TriggerConditionInput.fromMessageBasedTrigger((MessageBasedTriggerInput)builder.build());
    }

    public static TriggerConditionInput fromTokenBasedTrigger(TokenBasedTriggerInput tokenBasedTrigger) {
        return (TriggerConditionInput)TriggerConditionInput.builder().tokenBasedTrigger(tokenBasedTrigger).build();
    }

    public static TriggerConditionInput fromTokenBasedTrigger(Consumer<TokenBasedTriggerInput.Builder> tokenBasedTrigger) {
        TokenBasedTriggerInput.Builder builder = TokenBasedTriggerInput.builder();
        tokenBasedTrigger.accept(builder);
        return TriggerConditionInput.fromTokenBasedTrigger((TokenBasedTriggerInput)builder.build());
    }

    public static TriggerConditionInput fromTimeBasedTrigger(TimeBasedTriggerInput timeBasedTrigger) {
        return (TriggerConditionInput)TriggerConditionInput.builder().timeBasedTrigger(timeBasedTrigger).build();
    }

    public static TriggerConditionInput fromTimeBasedTrigger(Consumer<TimeBasedTriggerInput.Builder> timeBasedTrigger) {
        TimeBasedTriggerInput.Builder builder = TimeBasedTriggerInput.builder();
        timeBasedTrigger.accept(builder);
        return TriggerConditionInput.fromTimeBasedTrigger((TimeBasedTriggerInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageBasedTrigger", MESSAGE_BASED_TRIGGER_FIELD);
        map.put("tokenBasedTrigger", TOKEN_BASED_TRIGGER_FIELD);
        map.put("timeBasedTrigger", TIME_BASED_TRIGGER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TriggerConditionInput, T> g) {
        return obj -> g.apply((TriggerConditionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        MESSAGE_BASED_TRIGGER,
        TOKEN_BASED_TRIGGER,
        TIME_BASED_TRIGGER,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private MessageBasedTriggerInput messageBasedTrigger;
        private TokenBasedTriggerInput tokenBasedTrigger;
        private TimeBasedTriggerInput timeBasedTrigger;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerConditionInput model) {
            this.messageBasedTrigger(model.messageBasedTrigger);
            this.tokenBasedTrigger(model.tokenBasedTrigger);
            this.timeBasedTrigger(model.timeBasedTrigger);
        }

        public final MessageBasedTriggerInput.Builder getMessageBasedTrigger() {
            return this.messageBasedTrigger != null ? this.messageBasedTrigger.toBuilder() : null;
        }

        public final void setMessageBasedTrigger(MessageBasedTriggerInput.BuilderImpl messageBasedTrigger) {
            MessageBasedTriggerInput oldValue = this.messageBasedTrigger;
            this.messageBasedTrigger = messageBasedTrigger != null ? messageBasedTrigger.build() : null;
            this.handleUnionValueChange(Type.MESSAGE_BASED_TRIGGER, oldValue, this.messageBasedTrigger);
        }

        @Override
        public final Builder messageBasedTrigger(MessageBasedTriggerInput messageBasedTrigger) {
            MessageBasedTriggerInput oldValue = this.messageBasedTrigger;
            this.messageBasedTrigger = messageBasedTrigger;
            this.handleUnionValueChange(Type.MESSAGE_BASED_TRIGGER, oldValue, this.messageBasedTrigger);
            return this;
        }

        public final TokenBasedTriggerInput.Builder getTokenBasedTrigger() {
            return this.tokenBasedTrigger != null ? this.tokenBasedTrigger.toBuilder() : null;
        }

        public final void setTokenBasedTrigger(TokenBasedTriggerInput.BuilderImpl tokenBasedTrigger) {
            TokenBasedTriggerInput oldValue = this.tokenBasedTrigger;
            this.tokenBasedTrigger = tokenBasedTrigger != null ? tokenBasedTrigger.build() : null;
            this.handleUnionValueChange(Type.TOKEN_BASED_TRIGGER, oldValue, this.tokenBasedTrigger);
        }

        @Override
        public final Builder tokenBasedTrigger(TokenBasedTriggerInput tokenBasedTrigger) {
            TokenBasedTriggerInput oldValue = this.tokenBasedTrigger;
            this.tokenBasedTrigger = tokenBasedTrigger;
            this.handleUnionValueChange(Type.TOKEN_BASED_TRIGGER, oldValue, this.tokenBasedTrigger);
            return this;
        }

        public final TimeBasedTriggerInput.Builder getTimeBasedTrigger() {
            return this.timeBasedTrigger != null ? this.timeBasedTrigger.toBuilder() : null;
        }

        public final void setTimeBasedTrigger(TimeBasedTriggerInput.BuilderImpl timeBasedTrigger) {
            TimeBasedTriggerInput oldValue = this.timeBasedTrigger;
            this.timeBasedTrigger = timeBasedTrigger != null ? timeBasedTrigger.build() : null;
            this.handleUnionValueChange(Type.TIME_BASED_TRIGGER, oldValue, this.timeBasedTrigger);
        }

        @Override
        public final Builder timeBasedTrigger(TimeBasedTriggerInput timeBasedTrigger) {
            TimeBasedTriggerInput oldValue = this.timeBasedTrigger;
            this.timeBasedTrigger = timeBasedTrigger;
            this.handleUnionValueChange(Type.TIME_BASED_TRIGGER, oldValue, this.timeBasedTrigger);
            return this;
        }

        public TriggerConditionInput build() {
            return new TriggerConditionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TriggerConditionInput> {
        public Builder messageBasedTrigger(MessageBasedTriggerInput var1);

        default public Builder messageBasedTrigger(Consumer<MessageBasedTriggerInput.Builder> messageBasedTrigger) {
            return this.messageBasedTrigger((MessageBasedTriggerInput)((MessageBasedTriggerInput.Builder)MessageBasedTriggerInput.builder().applyMutation(messageBasedTrigger)).build());
        }

        public Builder tokenBasedTrigger(TokenBasedTriggerInput var1);

        default public Builder tokenBasedTrigger(Consumer<TokenBasedTriggerInput.Builder> tokenBasedTrigger) {
            return this.tokenBasedTrigger((TokenBasedTriggerInput)((TokenBasedTriggerInput.Builder)TokenBasedTriggerInput.builder().applyMutation(tokenBasedTrigger)).build());
        }

        public Builder timeBasedTrigger(TimeBasedTriggerInput var1);

        default public Builder timeBasedTrigger(Consumer<TimeBasedTriggerInput.Builder> timeBasedTrigger) {
            return this.timeBasedTrigger((TimeBasedTriggerInput)((TimeBasedTriggerInput.Builder)TimeBasedTriggerInput.builder().applyMutation(timeBasedTrigger)).build());
        }
    }
}

