/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ModifyMemoryStrategies;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMemoryRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, UpdateMemoryRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateMemoryRequest.getter(UpdateMemoryRequest::clientToken)).setter(UpdateMemoryRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MEMORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryId").getter(UpdateMemoryRequest.getter(UpdateMemoryRequest::memoryId)).setter(UpdateMemoryRequest.setter(Builder::memoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memoryId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateMemoryRequest.getter(UpdateMemoryRequest::description)).setter(UpdateMemoryRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Integer> EVENT_EXPIRY_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("eventExpiryDuration").getter(UpdateMemoryRequest.getter(UpdateMemoryRequest::eventExpiryDuration)).setter(UpdateMemoryRequest.setter(Builder::eventExpiryDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventExpiryDuration").build()}).build();
    private static final SdkField<String> MEMORY_EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memoryExecutionRoleArn").getter(UpdateMemoryRequest.getter(UpdateMemoryRequest::memoryExecutionRoleArn)).setter(UpdateMemoryRequest.setter(Builder::memoryExecutionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryExecutionRoleArn").build()}).build();
    private static final SdkField<ModifyMemoryStrategies> MEMORY_STRATEGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memoryStrategies").getter(UpdateMemoryRequest.getter(UpdateMemoryRequest::memoryStrategies)).setter(UpdateMemoryRequest.setter(Builder::memoryStrategies)).constructor(ModifyMemoryStrategies::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryStrategies").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, MEMORY_ID_FIELD, DESCRIPTION_FIELD, EVENT_EXPIRY_DURATION_FIELD, MEMORY_EXECUTION_ROLE_ARN_FIELD, MEMORY_STRATEGIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMemoryRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String memoryId;
    private final String description;
    private final Integer eventExpiryDuration;
    private final String memoryExecutionRoleArn;
    private final ModifyMemoryStrategies memoryStrategies;

    private UpdateMemoryRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.memoryId = builder.memoryId;
        this.description = builder.description;
        this.eventExpiryDuration = builder.eventExpiryDuration;
        this.memoryExecutionRoleArn = builder.memoryExecutionRoleArn;
        this.memoryStrategies = builder.memoryStrategies;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String memoryId() {
        return this.memoryId;
    }

    public final String description() {
        return this.description;
    }

    public final Integer eventExpiryDuration() {
        return this.eventExpiryDuration;
    }

    public final String memoryExecutionRoleArn() {
        return this.memoryExecutionRoleArn;
    }

    public final ModifyMemoryStrategies memoryStrategies() {
        return this.memoryStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventExpiryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryStrategies());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMemoryRequest)) {
            return false;
        }
        UpdateMemoryRequest other = (UpdateMemoryRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.memoryId(), other.memoryId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.eventExpiryDuration(), other.eventExpiryDuration()) && Objects.equals(this.memoryExecutionRoleArn(), other.memoryExecutionRoleArn()) && Objects.equals(this.memoryStrategies(), other.memoryStrategies());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMemoryRequest").add("ClientToken", (Object)this.clientToken()).add("MemoryId", (Object)this.memoryId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EventExpiryDuration", (Object)this.eventExpiryDuration()).add("MemoryExecutionRoleArn", (Object)this.memoryExecutionRoleArn()).add("MemoryStrategies", (Object)this.memoryStrategies()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "memoryId": {
                return Optional.ofNullable(clazz.cast(this.memoryId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "eventExpiryDuration": {
                return Optional.ofNullable(clazz.cast(this.eventExpiryDuration()));
            }
            case "memoryExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.memoryExecutionRoleArn()));
            }
            case "memoryStrategies": {
                return Optional.ofNullable(clazz.cast(this.memoryStrategies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("memoryId", MEMORY_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("eventExpiryDuration", EVENT_EXPIRY_DURATION_FIELD);
        map.put("memoryExecutionRoleArn", MEMORY_EXECUTION_ROLE_ARN_FIELD);
        map.put("memoryStrategies", MEMORY_STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMemoryRequest, T> g) {
        return obj -> g.apply((UpdateMemoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String memoryId;
        private String description;
        private Integer eventExpiryDuration;
        private String memoryExecutionRoleArn;
        private ModifyMemoryStrategies memoryStrategies;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMemoryRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.memoryId(model.memoryId);
            this.description(model.description);
            this.eventExpiryDuration(model.eventExpiryDuration);
            this.memoryExecutionRoleArn(model.memoryExecutionRoleArn);
            this.memoryStrategies(model.memoryStrategies);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getMemoryId() {
            return this.memoryId;
        }

        public final void setMemoryId(String memoryId) {
            this.memoryId = memoryId;
        }

        @Override
        public final Builder memoryId(String memoryId) {
            this.memoryId = memoryId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getEventExpiryDuration() {
            return this.eventExpiryDuration;
        }

        public final void setEventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
        }

        @Override
        public final Builder eventExpiryDuration(Integer eventExpiryDuration) {
            this.eventExpiryDuration = eventExpiryDuration;
            return this;
        }

        public final String getMemoryExecutionRoleArn() {
            return this.memoryExecutionRoleArn;
        }

        public final void setMemoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
        }

        @Override
        public final Builder memoryExecutionRoleArn(String memoryExecutionRoleArn) {
            this.memoryExecutionRoleArn = memoryExecutionRoleArn;
            return this;
        }

        public final ModifyMemoryStrategies.Builder getMemoryStrategies() {
            return this.memoryStrategies != null ? this.memoryStrategies.toBuilder() : null;
        }

        public final void setMemoryStrategies(ModifyMemoryStrategies.BuilderImpl memoryStrategies) {
            this.memoryStrategies = memoryStrategies != null ? memoryStrategies.build() : null;
        }

        @Override
        public final Builder memoryStrategies(ModifyMemoryStrategies memoryStrategies) {
            this.memoryStrategies = memoryStrategies;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMemoryRequest build() {
            return new UpdateMemoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMemoryRequest> {
        public Builder clientToken(String var1);

        public Builder memoryId(String var1);

        public Builder description(String var1);

        public Builder eventExpiryDuration(Integer var1);

        public Builder memoryExecutionRoleArn(String var1);

        public Builder memoryStrategies(ModifyMemoryStrategies var1);

        default public Builder memoryStrategies(Consumer<ModifyMemoryStrategies.Builder> memoryStrategies) {
            return this.memoryStrategies((ModifyMemoryStrategies)((ModifyMemoryStrategies.Builder)ModifyMemoryStrategies.builder().applyMutation(memoryStrategies)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

