/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CredentialProviderVendorType;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.Oauth2ProviderConfigInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOauth2CredentialProviderRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, UpdateOauth2CredentialProviderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateOauth2CredentialProviderRequest.getter(UpdateOauth2CredentialProviderRequest::name)).setter(UpdateOauth2CredentialProviderRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> CREDENTIAL_PROVIDER_VENDOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialProviderVendor").getter(UpdateOauth2CredentialProviderRequest.getter(UpdateOauth2CredentialProviderRequest::credentialProviderVendorAsString)).setter(UpdateOauth2CredentialProviderRequest.setter(Builder::credentialProviderVendor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviderVendor").build()}).build();
    private static final SdkField<Oauth2ProviderConfigInput> OAUTH2_PROVIDER_CONFIG_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("oauth2ProviderConfigInput").getter(UpdateOauth2CredentialProviderRequest.getter(UpdateOauth2CredentialProviderRequest::oauth2ProviderConfigInput)).setter(UpdateOauth2CredentialProviderRequest.setter(Builder::oauth2ProviderConfigInput)).constructor(Oauth2ProviderConfigInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauth2ProviderConfigInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CREDENTIAL_PROVIDER_VENDOR_FIELD, OAUTH2_PROVIDER_CONFIG_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOauth2CredentialProviderRequest.memberNameToFieldInitializer();
    private final String name;
    private final String credentialProviderVendor;
    private final Oauth2ProviderConfigInput oauth2ProviderConfigInput;

    private UpdateOauth2CredentialProviderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.credentialProviderVendor = builder.credentialProviderVendor;
        this.oauth2ProviderConfigInput = builder.oauth2ProviderConfigInput;
    }

    public final String name() {
        return this.name;
    }

    public final CredentialProviderVendorType credentialProviderVendor() {
        return CredentialProviderVendorType.fromValue(this.credentialProviderVendor);
    }

    public final String credentialProviderVendorAsString() {
        return this.credentialProviderVendor;
    }

    public final Oauth2ProviderConfigInput oauth2ProviderConfigInput() {
        return this.oauth2ProviderConfigInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialProviderVendorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oauth2ProviderConfigInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOauth2CredentialProviderRequest)) {
            return false;
        }
        UpdateOauth2CredentialProviderRequest other = (UpdateOauth2CredentialProviderRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.credentialProviderVendorAsString(), other.credentialProviderVendorAsString()) && Objects.equals(this.oauth2ProviderConfigInput(), other.oauth2ProviderConfigInput());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOauth2CredentialProviderRequest").add("Name", (Object)this.name()).add("CredentialProviderVendor", (Object)this.credentialProviderVendorAsString()).add("Oauth2ProviderConfigInput", (Object)this.oauth2ProviderConfigInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "credentialProviderVendor": {
                return Optional.ofNullable(clazz.cast(this.credentialProviderVendorAsString()));
            }
            case "oauth2ProviderConfigInput": {
                return Optional.ofNullable(clazz.cast(this.oauth2ProviderConfigInput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("credentialProviderVendor", CREDENTIAL_PROVIDER_VENDOR_FIELD);
        map.put("oauth2ProviderConfigInput", OAUTH2_PROVIDER_CONFIG_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOauth2CredentialProviderRequest, T> g) {
        return obj -> g.apply((UpdateOauth2CredentialProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String name;
        private String credentialProviderVendor;
        private Oauth2ProviderConfigInput oauth2ProviderConfigInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOauth2CredentialProviderRequest model) {
            super(model);
            this.name(model.name);
            this.credentialProviderVendor(model.credentialProviderVendor);
            this.oauth2ProviderConfigInput(model.oauth2ProviderConfigInput);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCredentialProviderVendor() {
            return this.credentialProviderVendor;
        }

        public final void setCredentialProviderVendor(String credentialProviderVendor) {
            this.credentialProviderVendor = credentialProviderVendor;
        }

        @Override
        public final Builder credentialProviderVendor(String credentialProviderVendor) {
            this.credentialProviderVendor = credentialProviderVendor;
            return this;
        }

        @Override
        public final Builder credentialProviderVendor(CredentialProviderVendorType credentialProviderVendor) {
            this.credentialProviderVendor(credentialProviderVendor == null ? null : credentialProviderVendor.toString());
            return this;
        }

        public final Oauth2ProviderConfigInput.Builder getOauth2ProviderConfigInput() {
            return this.oauth2ProviderConfigInput != null ? this.oauth2ProviderConfigInput.toBuilder() : null;
        }

        public final void setOauth2ProviderConfigInput(Oauth2ProviderConfigInput.BuilderImpl oauth2ProviderConfigInput) {
            this.oauth2ProviderConfigInput = oauth2ProviderConfigInput != null ? oauth2ProviderConfigInput.build() : null;
        }

        @Override
        public final Builder oauth2ProviderConfigInput(Oauth2ProviderConfigInput oauth2ProviderConfigInput) {
            this.oauth2ProviderConfigInput = oauth2ProviderConfigInput;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOauth2CredentialProviderRequest build() {
            return new UpdateOauth2CredentialProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOauth2CredentialProviderRequest> {
        public Builder name(String var1);

        public Builder credentialProviderVendor(String var1);

        public Builder credentialProviderVendor(CredentialProviderVendorType var1);

        public Builder oauth2ProviderConfigInput(Oauth2ProviderConfigInput var1);

        default public Builder oauth2ProviderConfigInput(Consumer<Oauth2ProviderConfigInput.Builder> oauth2ProviderConfigInput) {
            return this.oauth2ProviderConfigInput((Oauth2ProviderConfigInput)((Oauth2ProviderConfigInput.Builder)Oauth2ProviderConfigInput.builder().applyMutation(oauth2ProviderConfigInput)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

