/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationConfigStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOnlineEvaluationConfigResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, UpdateOnlineEvaluationConfigResponse> {
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigArn").getter(UpdateOnlineEvaluationConfigResponse.getter(UpdateOnlineEvaluationConfigResponse::onlineEvaluationConfigArn)).setter(UpdateOnlineEvaluationConfigResponse.setter(Builder::onlineEvaluationConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigArn").build()}).build();
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigId").getter(UpdateOnlineEvaluationConfigResponse.getter(UpdateOnlineEvaluationConfigResponse::onlineEvaluationConfigId)).setter(UpdateOnlineEvaluationConfigResponse.setter(Builder::onlineEvaluationConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdateOnlineEvaluationConfigResponse.getter(UpdateOnlineEvaluationConfigResponse::updatedAt)).setter(UpdateOnlineEvaluationConfigResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateOnlineEvaluationConfigResponse.getter(UpdateOnlineEvaluationConfigResponse::statusAsString)).setter(UpdateOnlineEvaluationConfigResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStatus").getter(UpdateOnlineEvaluationConfigResponse.getter(UpdateOnlineEvaluationConfigResponse::executionStatusAsString)).setter(UpdateOnlineEvaluationConfigResponse.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(UpdateOnlineEvaluationConfigResponse.getter(UpdateOnlineEvaluationConfigResponse::failureReason)).setter(UpdateOnlineEvaluationConfigResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONLINE_EVALUATION_CONFIG_ARN_FIELD, ONLINE_EVALUATION_CONFIG_ID_FIELD, UPDATED_AT_FIELD, STATUS_FIELD, EXECUTION_STATUS_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOnlineEvaluationConfigResponse.memberNameToFieldInitializer();
    private final String onlineEvaluationConfigArn;
    private final String onlineEvaluationConfigId;
    private final Instant updatedAt;
    private final String status;
    private final String executionStatus;
    private final String failureReason;

    private UpdateOnlineEvaluationConfigResponse(BuilderImpl builder) {
        super(builder);
        this.onlineEvaluationConfigArn = builder.onlineEvaluationConfigArn;
        this.onlineEvaluationConfigId = builder.onlineEvaluationConfigId;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
        this.executionStatus = builder.executionStatus;
        this.failureReason = builder.failureReason;
    }

    public final String onlineEvaluationConfigArn() {
        return this.onlineEvaluationConfigArn;
    }

    public final String onlineEvaluationConfigId() {
        return this.onlineEvaluationConfigId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final OnlineEvaluationConfigStatus status() {
        return OnlineEvaluationConfigStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final OnlineEvaluationExecutionStatus executionStatus() {
        return OnlineEvaluationExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOnlineEvaluationConfigResponse)) {
            return false;
        }
        UpdateOnlineEvaluationConfigResponse other = (UpdateOnlineEvaluationConfigResponse)((Object)obj);
        return Objects.equals(this.onlineEvaluationConfigArn(), other.onlineEvaluationConfigArn()) && Objects.equals(this.onlineEvaluationConfigId(), other.onlineEvaluationConfigId()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOnlineEvaluationConfigResponse").add("OnlineEvaluationConfigArn", (Object)this.onlineEvaluationConfigArn()).add("OnlineEvaluationConfigId", (Object)this.onlineEvaluationConfigId()).add("UpdatedAt", (Object)this.updatedAt()).add("Status", (Object)this.statusAsString()).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "onlineEvaluationConfigArn": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigArn()));
            }
            case "onlineEvaluationConfigId": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigId()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("onlineEvaluationConfigArn", ONLINE_EVALUATION_CONFIG_ARN_FIELD);
        map.put("onlineEvaluationConfigId", ONLINE_EVALUATION_CONFIG_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOnlineEvaluationConfigResponse, T> g) {
        return obj -> g.apply((UpdateOnlineEvaluationConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String onlineEvaluationConfigArn;
        private String onlineEvaluationConfigId;
        private Instant updatedAt;
        private String status;
        private String executionStatus;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOnlineEvaluationConfigResponse model) {
            super(model);
            this.onlineEvaluationConfigArn(model.onlineEvaluationConfigArn);
            this.onlineEvaluationConfigId(model.onlineEvaluationConfigId);
            this.updatedAt(model.updatedAt);
            this.status(model.status);
            this.executionStatus(model.executionStatus);
            this.failureReason(model.failureReason);
        }

        public final String getOnlineEvaluationConfigArn() {
            return this.onlineEvaluationConfigArn;
        }

        public final void setOnlineEvaluationConfigArn(String onlineEvaluationConfigArn) {
            this.onlineEvaluationConfigArn = onlineEvaluationConfigArn;
        }

        @Override
        public final Builder onlineEvaluationConfigArn(String onlineEvaluationConfigArn) {
            this.onlineEvaluationConfigArn = onlineEvaluationConfigArn;
            return this;
        }

        public final String getOnlineEvaluationConfigId() {
            return this.onlineEvaluationConfigId;
        }

        public final void setOnlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
        }

        @Override
        public final Builder onlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OnlineEvaluationConfigStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(OnlineEvaluationExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public UpdateOnlineEvaluationConfigResponse build() {
            return new UpdateOnlineEvaluationConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOnlineEvaluationConfigResponse> {
        public Builder onlineEvaluationConfigArn(String var1);

        public Builder onlineEvaluationConfigId(String var1);

        public Builder updatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(OnlineEvaluationConfigStatus var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(OnlineEvaluationExecutionStatus var1);

        public Builder failureReason(String var1);
    }
}

