/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorSummary;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListEvaluatorsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListEvaluatorsResponse;

public class ListEvaluatorsIterable
implements SdkIterable<ListEvaluatorsResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListEvaluatorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEvaluatorsIterable(BedrockAgentCoreControlClient client, ListEvaluatorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEvaluatorsResponseFetcher();
    }

    public Iterator<ListEvaluatorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EvaluatorSummary> evaluators() {
        Function<ListEvaluatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluators() != null) {
                return response.evaluators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEvaluatorsResponseFetcher
    implements SyncPageFetcher<ListEvaluatorsResponse> {
        private ListEvaluatorsResponseFetcher() {
        }

        public boolean hasNextPage(ListEvaluatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEvaluatorsResponse nextPage(ListEvaluatorsResponse previousPage) {
            if (previousPage == null) {
                return ListEvaluatorsIterable.this.client.listEvaluators(ListEvaluatorsIterable.this.firstRequest);
            }
            return ListEvaluatorsIterable.this.client.listEvaluators((ListEvaluatorsRequest)((Object)ListEvaluatorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

