/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyGenerationsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListPolicyGenerationsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.PolicyGeneration;

public class ListPolicyGenerationsPublisher
implements SdkPublisher<ListPolicyGenerationsResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListPolicyGenerationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyGenerationsPublisher(BedrockAgentCoreControlAsyncClient client, ListPolicyGenerationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyGenerationsPublisher(BedrockAgentCoreControlAsyncClient client, ListPolicyGenerationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyGenerationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyGenerationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PolicyGeneration> policyGenerations() {
        Function<ListPolicyGenerationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyGenerations() != null) {
                return response.policyGenerations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPolicyGenerationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPolicyGenerationsResponseFetcher
    implements AsyncPageFetcher<ListPolicyGenerationsResponse> {
        private ListPolicyGenerationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyGenerationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPolicyGenerationsResponse> nextPage(ListPolicyGenerationsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyGenerationsPublisher.this.client.listPolicyGenerations(ListPolicyGenerationsPublisher.this.firstRequest);
            }
            return ListPolicyGenerationsPublisher.this.client.listPolicyGenerations((ListPolicyGenerationsRequest)((Object)ListPolicyGenerationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

