/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chatbot.model.ChatbotResponse;
import software.amazon.awssdk.services.chatbot.model.ChimeWebhookConfiguration;
import software.amazon.awssdk.services.chatbot.model.ChimeWebhookConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeChimeWebhookConfigurationsResponse
extends ChatbotResponse
implements ToCopyableBuilder<Builder, DescribeChimeWebhookConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeChimeWebhookConfigurationsResponse.getter(DescribeChimeWebhookConfigurationsResponse::nextToken)).setter(DescribeChimeWebhookConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ChimeWebhookConfiguration>> WEBHOOK_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WebhookConfigurations").getter(DescribeChimeWebhookConfigurationsResponse.getter(DescribeChimeWebhookConfigurationsResponse::webhookConfigurations)).setter(DescribeChimeWebhookConfigurationsResponse.setter(Builder::webhookConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebhookConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChimeWebhookConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WEBHOOK_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeChimeWebhookConfigurationsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ChimeWebhookConfiguration> webhookConfigurations;

    private DescribeChimeWebhookConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.webhookConfigurations = builder.webhookConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWebhookConfigurations() {
        return this.webhookConfigurations != null && !(this.webhookConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ChimeWebhookConfiguration> webhookConfigurations() {
        return this.webhookConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWebhookConfigurations() ? this.webhookConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChimeWebhookConfigurationsResponse)) {
            return false;
        }
        DescribeChimeWebhookConfigurationsResponse other = (DescribeChimeWebhookConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWebhookConfigurations() == other.hasWebhookConfigurations() && Objects.equals(this.webhookConfigurations(), other.webhookConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeChimeWebhookConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("WebhookConfigurations", this.hasWebhookConfigurations() ? this.webhookConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "WebhookConfigurations": {
                return Optional.ofNullable(clazz.cast(this.webhookConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WebhookConfigurations", WEBHOOK_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeChimeWebhookConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeChimeWebhookConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChatbotResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ChimeWebhookConfiguration> webhookConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChimeWebhookConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.webhookConfigurations(model.webhookConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ChimeWebhookConfiguration.Builder> getWebhookConfigurations() {
            List<ChimeWebhookConfiguration.Builder> result = ChimeWebhookConfigurationListCopier.copyToBuilder(this.webhookConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebhookConfigurations(Collection<ChimeWebhookConfiguration.BuilderImpl> webhookConfigurations) {
            this.webhookConfigurations = ChimeWebhookConfigurationListCopier.copyFromBuilder(webhookConfigurations);
        }

        @Override
        public final Builder webhookConfigurations(Collection<ChimeWebhookConfiguration> webhookConfigurations) {
            this.webhookConfigurations = ChimeWebhookConfigurationListCopier.copy(webhookConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webhookConfigurations(ChimeWebhookConfiguration ... webhookConfigurations) {
            this.webhookConfigurations(Arrays.asList(webhookConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webhookConfigurations(Consumer<ChimeWebhookConfiguration.Builder> ... webhookConfigurations) {
            this.webhookConfigurations(Stream.of(webhookConfigurations).map(c -> (ChimeWebhookConfiguration)((ChimeWebhookConfiguration.Builder)ChimeWebhookConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeChimeWebhookConfigurationsResponse build() {
            return new DescribeChimeWebhookConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChatbotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeChimeWebhookConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder webhookConfigurations(Collection<ChimeWebhookConfiguration> var1);

        public Builder webhookConfigurations(ChimeWebhookConfiguration ... var1);

        public Builder webhookConfigurations(Consumer<ChimeWebhookConfiguration.Builder> ... var1);
    }
}

