/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeSlackUserIdentitiesResponse;
import software.amazon.awssdk.services.chatbot.model.SlackUserIdentity;

public class DescribeSlackUserIdentitiesIterable
implements SdkIterable<DescribeSlackUserIdentitiesResponse> {
    private final ChatbotClient client;
    private final DescribeSlackUserIdentitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSlackUserIdentitiesIterable(ChatbotClient client, DescribeSlackUserIdentitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSlackUserIdentitiesResponseFetcher();
    }

    public Iterator<DescribeSlackUserIdentitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SlackUserIdentity> slackUserIdentities() {
        Function<DescribeSlackUserIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.slackUserIdentities() != null) {
                return response.slackUserIdentities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSlackUserIdentitiesResponseFetcher
    implements SyncPageFetcher<DescribeSlackUserIdentitiesResponse> {
        private DescribeSlackUserIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSlackUserIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSlackUserIdentitiesResponse nextPage(DescribeSlackUserIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSlackUserIdentitiesIterable.this.client.describeSlackUserIdentities(DescribeSlackUserIdentitiesIterable.this.firstRequest);
            }
            return DescribeSlackUserIdentitiesIterable.this.client.describeSlackUserIdentities((DescribeSlackUserIdentitiesRequest)((Object)DescribeSlackUserIdentitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

