/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamRecordingSourceRuntimeConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceRuntimeConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsRuntimeMetadataCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.S3RecordingSinkRuntimeConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.Tag;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMediaInsightsPipelineRequest
extends ChimeSdkMediaPipelinesRequest
implements ToCopyableBuilder<Builder, CreateMediaInsightsPipelineRequest> {
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaInsightsPipelineConfigurationArn").getter(CreateMediaInsightsPipelineRequest.getter(CreateMediaInsightsPipelineRequest::mediaInsightsPipelineConfigurationArn)).setter(CreateMediaInsightsPipelineRequest.setter(Builder::mediaInsightsPipelineConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsPipelineConfigurationArn").build()}).build();
    private static final SdkField<KinesisVideoStreamSourceRuntimeConfiguration> KINESIS_VIDEO_STREAM_SOURCE_RUNTIME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisVideoStreamSourceRuntimeConfiguration").getter(CreateMediaInsightsPipelineRequest.getter(CreateMediaInsightsPipelineRequest::kinesisVideoStreamSourceRuntimeConfiguration)).setter(CreateMediaInsightsPipelineRequest.setter(Builder::kinesisVideoStreamSourceRuntimeConfiguration)).constructor(KinesisVideoStreamSourceRuntimeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisVideoStreamSourceRuntimeConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> MEDIA_INSIGHTS_RUNTIME_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MediaInsightsRuntimeMetadata").getter(CreateMediaInsightsPipelineRequest.getter(CreateMediaInsightsPipelineRequest::mediaInsightsRuntimeMetadata)).setter(CreateMediaInsightsPipelineRequest.setter(Builder::mediaInsightsRuntimeMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsRuntimeMetadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<KinesisVideoStreamRecordingSourceRuntimeConfiguration> KINESIS_VIDEO_STREAM_RECORDING_SOURCE_RUNTIME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisVideoStreamRecordingSourceRuntimeConfiguration").getter(CreateMediaInsightsPipelineRequest.getter(CreateMediaInsightsPipelineRequest::kinesisVideoStreamRecordingSourceRuntimeConfiguration)).setter(CreateMediaInsightsPipelineRequest.setter(Builder::kinesisVideoStreamRecordingSourceRuntimeConfiguration)).constructor(KinesisVideoStreamRecordingSourceRuntimeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisVideoStreamRecordingSourceRuntimeConfiguration").build()}).build();
    private static final SdkField<S3RecordingSinkRuntimeConfiguration> S3_RECORDING_SINK_RUNTIME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3RecordingSinkRuntimeConfiguration").getter(CreateMediaInsightsPipelineRequest.getter(CreateMediaInsightsPipelineRequest::s3RecordingSinkRuntimeConfiguration)).setter(CreateMediaInsightsPipelineRequest.setter(Builder::s3RecordingSinkRuntimeConfiguration)).constructor(S3RecordingSinkRuntimeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3RecordingSinkRuntimeConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMediaInsightsPipelineRequest.getter(CreateMediaInsightsPipelineRequest::tags)).setter(CreateMediaInsightsPipelineRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateMediaInsightsPipelineRequest.getter(CreateMediaInsightsPipelineRequest::clientRequestToken)).setter(CreateMediaInsightsPipelineRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD, KINESIS_VIDEO_STREAM_SOURCE_RUNTIME_CONFIGURATION_FIELD, MEDIA_INSIGHTS_RUNTIME_METADATA_FIELD, KINESIS_VIDEO_STREAM_RECORDING_SOURCE_RUNTIME_CONFIGURATION_FIELD, S3_RECORDING_SINK_RUNTIME_CONFIGURATION_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMediaInsightsPipelineRequest.memberNameToFieldInitializer();
    private final String mediaInsightsPipelineConfigurationArn;
    private final KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration;
    private final Map<String, String> mediaInsightsRuntimeMetadata;
    private final KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration;
    private final S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration;
    private final List<Tag> tags;
    private final String clientRequestToken;

    private CreateMediaInsightsPipelineRequest(BuilderImpl builder) {
        super(builder);
        this.mediaInsightsPipelineConfigurationArn = builder.mediaInsightsPipelineConfigurationArn;
        this.kinesisVideoStreamSourceRuntimeConfiguration = builder.kinesisVideoStreamSourceRuntimeConfiguration;
        this.mediaInsightsRuntimeMetadata = builder.mediaInsightsRuntimeMetadata;
        this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = builder.kinesisVideoStreamRecordingSourceRuntimeConfiguration;
        this.s3RecordingSinkRuntimeConfiguration = builder.s3RecordingSinkRuntimeConfiguration;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String mediaInsightsPipelineConfigurationArn() {
        return this.mediaInsightsPipelineConfigurationArn;
    }

    public final KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration() {
        return this.kinesisVideoStreamSourceRuntimeConfiguration;
    }

    public final boolean hasMediaInsightsRuntimeMetadata() {
        return this.mediaInsightsRuntimeMetadata != null && !(this.mediaInsightsRuntimeMetadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> mediaInsightsRuntimeMetadata() {
        return this.mediaInsightsRuntimeMetadata;
    }

    public final KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration() {
        return this.kinesisVideoStreamRecordingSourceRuntimeConfiguration;
    }

    public final S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration() {
        return this.s3RecordingSinkRuntimeConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaInsightsPipelineConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisVideoStreamSourceRuntimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaInsightsRuntimeMetadata() ? this.mediaInsightsRuntimeMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisVideoStreamRecordingSourceRuntimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3RecordingSinkRuntimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMediaInsightsPipelineRequest)) {
            return false;
        }
        CreateMediaInsightsPipelineRequest other = (CreateMediaInsightsPipelineRequest)((Object)obj);
        return Objects.equals(this.mediaInsightsPipelineConfigurationArn(), other.mediaInsightsPipelineConfigurationArn()) && Objects.equals(this.kinesisVideoStreamSourceRuntimeConfiguration(), other.kinesisVideoStreamSourceRuntimeConfiguration()) && this.hasMediaInsightsRuntimeMetadata() == other.hasMediaInsightsRuntimeMetadata() && Objects.equals(this.mediaInsightsRuntimeMetadata(), other.mediaInsightsRuntimeMetadata()) && Objects.equals(this.kinesisVideoStreamRecordingSourceRuntimeConfiguration(), other.kinesisVideoStreamRecordingSourceRuntimeConfiguration()) && Objects.equals(this.s3RecordingSinkRuntimeConfiguration(), other.s3RecordingSinkRuntimeConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMediaInsightsPipelineRequest").add("MediaInsightsPipelineConfigurationArn", (Object)(this.mediaInsightsPipelineConfigurationArn() == null ? null : "*** Sensitive Data Redacted ***")).add("KinesisVideoStreamSourceRuntimeConfiguration", (Object)this.kinesisVideoStreamSourceRuntimeConfiguration()).add("MediaInsightsRuntimeMetadata", (Object)(this.mediaInsightsRuntimeMetadata() == null ? null : "*** Sensitive Data Redacted ***")).add("KinesisVideoStreamRecordingSourceRuntimeConfiguration", (Object)this.kinesisVideoStreamRecordingSourceRuntimeConfiguration()).add("S3RecordingSinkRuntimeConfiguration", (Object)this.s3RecordingSinkRuntimeConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaInsightsPipelineConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsPipelineConfigurationArn()));
            }
            case "KinesisVideoStreamSourceRuntimeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisVideoStreamSourceRuntimeConfiguration()));
            }
            case "MediaInsightsRuntimeMetadata": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsRuntimeMetadata()));
            }
            case "KinesisVideoStreamRecordingSourceRuntimeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisVideoStreamRecordingSourceRuntimeConfiguration()));
            }
            case "S3RecordingSinkRuntimeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3RecordingSinkRuntimeConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MediaInsightsPipelineConfigurationArn", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD);
        map.put("KinesisVideoStreamSourceRuntimeConfiguration", KINESIS_VIDEO_STREAM_SOURCE_RUNTIME_CONFIGURATION_FIELD);
        map.put("MediaInsightsRuntimeMetadata", MEDIA_INSIGHTS_RUNTIME_METADATA_FIELD);
        map.put("KinesisVideoStreamRecordingSourceRuntimeConfiguration", KINESIS_VIDEO_STREAM_RECORDING_SOURCE_RUNTIME_CONFIGURATION_FIELD);
        map.put("S3RecordingSinkRuntimeConfiguration", S3_RECORDING_SINK_RUNTIME_CONFIGURATION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMediaInsightsPipelineRequest, T> g) {
        return obj -> g.apply((CreateMediaInsightsPipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesRequest.BuilderImpl
    implements Builder {
        private String mediaInsightsPipelineConfigurationArn;
        private KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration;
        private Map<String, String> mediaInsightsRuntimeMetadata = DefaultSdkAutoConstructMap.getInstance();
        private KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration;
        private S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMediaInsightsPipelineRequest model) {
            super(model);
            this.mediaInsightsPipelineConfigurationArn(model.mediaInsightsPipelineConfigurationArn);
            this.kinesisVideoStreamSourceRuntimeConfiguration(model.kinesisVideoStreamSourceRuntimeConfiguration);
            this.mediaInsightsRuntimeMetadata(model.mediaInsightsRuntimeMetadata);
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration(model.kinesisVideoStreamRecordingSourceRuntimeConfiguration);
            this.s3RecordingSinkRuntimeConfiguration(model.s3RecordingSinkRuntimeConfiguration);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getMediaInsightsPipelineConfigurationArn() {
            return this.mediaInsightsPipelineConfigurationArn;
        }

        public final void setMediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
            return this;
        }

        public final KinesisVideoStreamSourceRuntimeConfiguration.Builder getKinesisVideoStreamSourceRuntimeConfiguration() {
            return this.kinesisVideoStreamSourceRuntimeConfiguration != null ? this.kinesisVideoStreamSourceRuntimeConfiguration.toBuilder() : null;
        }

        public final void setKinesisVideoStreamSourceRuntimeConfiguration(KinesisVideoStreamSourceRuntimeConfiguration.BuilderImpl kinesisVideoStreamSourceRuntimeConfiguration) {
            this.kinesisVideoStreamSourceRuntimeConfiguration = kinesisVideoStreamSourceRuntimeConfiguration != null ? kinesisVideoStreamSourceRuntimeConfiguration.build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamSourceRuntimeConfiguration(KinesisVideoStreamSourceRuntimeConfiguration kinesisVideoStreamSourceRuntimeConfiguration) {
            this.kinesisVideoStreamSourceRuntimeConfiguration = kinesisVideoStreamSourceRuntimeConfiguration;
            return this;
        }

        public final Map<String, String> getMediaInsightsRuntimeMetadata() {
            if (this.mediaInsightsRuntimeMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.mediaInsightsRuntimeMetadata;
        }

        public final void setMediaInsightsRuntimeMetadata(Map<String, String> mediaInsightsRuntimeMetadata) {
            this.mediaInsightsRuntimeMetadata = MediaInsightsRuntimeMetadataCopier.copy(mediaInsightsRuntimeMetadata);
        }

        @Override
        public final Builder mediaInsightsRuntimeMetadata(Map<String, String> mediaInsightsRuntimeMetadata) {
            this.mediaInsightsRuntimeMetadata = MediaInsightsRuntimeMetadataCopier.copy(mediaInsightsRuntimeMetadata);
            return this;
        }

        public final KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder getKinesisVideoStreamRecordingSourceRuntimeConfiguration() {
            return this.kinesisVideoStreamRecordingSourceRuntimeConfiguration != null ? this.kinesisVideoStreamRecordingSourceRuntimeConfiguration.toBuilder() : null;
        }

        public final void setKinesisVideoStreamRecordingSourceRuntimeConfiguration(KinesisVideoStreamRecordingSourceRuntimeConfiguration.BuilderImpl kinesisVideoStreamRecordingSourceRuntimeConfiguration) {
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = kinesisVideoStreamRecordingSourceRuntimeConfiguration != null ? kinesisVideoStreamRecordingSourceRuntimeConfiguration.build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamRecordingSourceRuntimeConfiguration(KinesisVideoStreamRecordingSourceRuntimeConfiguration kinesisVideoStreamRecordingSourceRuntimeConfiguration) {
            this.kinesisVideoStreamRecordingSourceRuntimeConfiguration = kinesisVideoStreamRecordingSourceRuntimeConfiguration;
            return this;
        }

        public final S3RecordingSinkRuntimeConfiguration.Builder getS3RecordingSinkRuntimeConfiguration() {
            return this.s3RecordingSinkRuntimeConfiguration != null ? this.s3RecordingSinkRuntimeConfiguration.toBuilder() : null;
        }

        public final void setS3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration.BuilderImpl s3RecordingSinkRuntimeConfiguration) {
            this.s3RecordingSinkRuntimeConfiguration = s3RecordingSinkRuntimeConfiguration != null ? s3RecordingSinkRuntimeConfiguration.build() : null;
        }

        @Override
        public final Builder s3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration s3RecordingSinkRuntimeConfiguration) {
            this.s3RecordingSinkRuntimeConfiguration = s3RecordingSinkRuntimeConfiguration;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMediaInsightsPipelineRequest build() {
            return new CreateMediaInsightsPipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkMediaPipelinesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMediaInsightsPipelineRequest> {
        public Builder mediaInsightsPipelineConfigurationArn(String var1);

        public Builder kinesisVideoStreamSourceRuntimeConfiguration(KinesisVideoStreamSourceRuntimeConfiguration var1);

        default public Builder kinesisVideoStreamSourceRuntimeConfiguration(Consumer<KinesisVideoStreamSourceRuntimeConfiguration.Builder> kinesisVideoStreamSourceRuntimeConfiguration) {
            return this.kinesisVideoStreamSourceRuntimeConfiguration((KinesisVideoStreamSourceRuntimeConfiguration)((KinesisVideoStreamSourceRuntimeConfiguration.Builder)KinesisVideoStreamSourceRuntimeConfiguration.builder().applyMutation(kinesisVideoStreamSourceRuntimeConfiguration)).build());
        }

        public Builder mediaInsightsRuntimeMetadata(Map<String, String> var1);

        public Builder kinesisVideoStreamRecordingSourceRuntimeConfiguration(KinesisVideoStreamRecordingSourceRuntimeConfiguration var1);

        default public Builder kinesisVideoStreamRecordingSourceRuntimeConfiguration(Consumer<KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder> kinesisVideoStreamRecordingSourceRuntimeConfiguration) {
            return this.kinesisVideoStreamRecordingSourceRuntimeConfiguration((KinesisVideoStreamRecordingSourceRuntimeConfiguration)((KinesisVideoStreamRecordingSourceRuntimeConfiguration.Builder)KinesisVideoStreamRecordingSourceRuntimeConfiguration.builder().applyMutation(kinesisVideoStreamRecordingSourceRuntimeConfiguration)).build());
        }

        public Builder s3RecordingSinkRuntimeConfiguration(S3RecordingSinkRuntimeConfiguration var1);

        default public Builder s3RecordingSinkRuntimeConfiguration(Consumer<S3RecordingSinkRuntimeConfiguration.Builder> s3RecordingSinkRuntimeConfiguration) {
            return this.s3RecordingSinkRuntimeConfiguration((S3RecordingSinkRuntimeConfiguration)((S3RecordingSinkRuntimeConfiguration.Builder)S3RecordingSinkRuntimeConfiguration.builder().applyMutation(s3RecordingSinkRuntimeConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

