/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElement;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.MediaInsightsPipelineConfigurationElementsCopier;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.RealTimeAlertConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaInsightsPipelineConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaInsightsPipelineConfiguration> {
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaInsightsPipelineConfigurationName").getter(MediaInsightsPipelineConfiguration.getter(MediaInsightsPipelineConfiguration::mediaInsightsPipelineConfigurationName)).setter(MediaInsightsPipelineConfiguration.setter(Builder::mediaInsightsPipelineConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsPipelineConfigurationName").build()}).build();
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaInsightsPipelineConfigurationArn").getter(MediaInsightsPipelineConfiguration.getter(MediaInsightsPipelineConfiguration::mediaInsightsPipelineConfigurationArn)).setter(MediaInsightsPipelineConfiguration.setter(Builder::mediaInsightsPipelineConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsPipelineConfigurationArn").build()}).build();
    private static final SdkField<String> RESOURCE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceAccessRoleArn").getter(MediaInsightsPipelineConfiguration.getter(MediaInsightsPipelineConfiguration::resourceAccessRoleArn)).setter(MediaInsightsPipelineConfiguration.setter(Builder::resourceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAccessRoleArn").build()}).build();
    private static final SdkField<RealTimeAlertConfiguration> REAL_TIME_ALERT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RealTimeAlertConfiguration").getter(MediaInsightsPipelineConfiguration.getter(MediaInsightsPipelineConfiguration::realTimeAlertConfiguration)).setter(MediaInsightsPipelineConfiguration.setter(Builder::realTimeAlertConfiguration)).constructor(RealTimeAlertConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeAlertConfiguration").build()}).build();
    private static final SdkField<List<MediaInsightsPipelineConfigurationElement>> ELEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Elements").getter(MediaInsightsPipelineConfiguration.getter(MediaInsightsPipelineConfiguration::elements)).setter(MediaInsightsPipelineConfiguration.setter(Builder::elements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Elements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaInsightsPipelineConfigurationElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaInsightsPipelineConfigurationId").getter(MediaInsightsPipelineConfiguration.getter(MediaInsightsPipelineConfiguration::mediaInsightsPipelineConfigurationId)).setter(MediaInsightsPipelineConfiguration.setter(Builder::mediaInsightsPipelineConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaInsightsPipelineConfigurationId").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(MediaInsightsPipelineConfiguration.getter(MediaInsightsPipelineConfiguration::createdTimestamp)).setter(MediaInsightsPipelineConfiguration.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(MediaInsightsPipelineConfiguration.getter(MediaInsightsPipelineConfiguration::updatedTimestamp)).setter(MediaInsightsPipelineConfiguration.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD, MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD, RESOURCE_ACCESS_ROLE_ARN_FIELD, REAL_TIME_ALERT_CONFIGURATION_FIELD, ELEMENTS_FIELD, MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ID_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaInsightsPipelineConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mediaInsightsPipelineConfigurationName;
    private final String mediaInsightsPipelineConfigurationArn;
    private final String resourceAccessRoleArn;
    private final RealTimeAlertConfiguration realTimeAlertConfiguration;
    private final List<MediaInsightsPipelineConfigurationElement> elements;
    private final String mediaInsightsPipelineConfigurationId;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private MediaInsightsPipelineConfiguration(BuilderImpl builder) {
        this.mediaInsightsPipelineConfigurationName = builder.mediaInsightsPipelineConfigurationName;
        this.mediaInsightsPipelineConfigurationArn = builder.mediaInsightsPipelineConfigurationArn;
        this.resourceAccessRoleArn = builder.resourceAccessRoleArn;
        this.realTimeAlertConfiguration = builder.realTimeAlertConfiguration;
        this.elements = builder.elements;
        this.mediaInsightsPipelineConfigurationId = builder.mediaInsightsPipelineConfigurationId;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String mediaInsightsPipelineConfigurationName() {
        return this.mediaInsightsPipelineConfigurationName;
    }

    public final String mediaInsightsPipelineConfigurationArn() {
        return this.mediaInsightsPipelineConfigurationArn;
    }

    public final String resourceAccessRoleArn() {
        return this.resourceAccessRoleArn;
    }

    public final RealTimeAlertConfiguration realTimeAlertConfiguration() {
        return this.realTimeAlertConfiguration;
    }

    public final boolean hasElements() {
        return this.elements != null && !(this.elements instanceof SdkAutoConstructList);
    }

    public final List<MediaInsightsPipelineConfigurationElement> elements() {
        return this.elements;
    }

    public final String mediaInsightsPipelineConfigurationId() {
        return this.mediaInsightsPipelineConfigurationId;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaInsightsPipelineConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaInsightsPipelineConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.realTimeAlertConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElements() ? this.elements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaInsightsPipelineConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaInsightsPipelineConfiguration)) {
            return false;
        }
        MediaInsightsPipelineConfiguration other = (MediaInsightsPipelineConfiguration)obj;
        return Objects.equals(this.mediaInsightsPipelineConfigurationName(), other.mediaInsightsPipelineConfigurationName()) && Objects.equals(this.mediaInsightsPipelineConfigurationArn(), other.mediaInsightsPipelineConfigurationArn()) && Objects.equals(this.resourceAccessRoleArn(), other.resourceAccessRoleArn()) && Objects.equals(this.realTimeAlertConfiguration(), other.realTimeAlertConfiguration()) && this.hasElements() == other.hasElements() && Objects.equals(this.elements(), other.elements()) && Objects.equals(this.mediaInsightsPipelineConfigurationId(), other.mediaInsightsPipelineConfigurationId()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"MediaInsightsPipelineConfiguration").add("MediaInsightsPipelineConfigurationName", (Object)this.mediaInsightsPipelineConfigurationName()).add("MediaInsightsPipelineConfigurationArn", (Object)(this.mediaInsightsPipelineConfigurationArn() == null ? null : "*** Sensitive Data Redacted ***")).add("ResourceAccessRoleArn", (Object)(this.resourceAccessRoleArn() == null ? null : "*** Sensitive Data Redacted ***")).add("RealTimeAlertConfiguration", (Object)this.realTimeAlertConfiguration()).add("Elements", this.hasElements() ? this.elements() : null).add("MediaInsightsPipelineConfigurationId", (Object)this.mediaInsightsPipelineConfigurationId()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaInsightsPipelineConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsPipelineConfigurationName()));
            }
            case "MediaInsightsPipelineConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsPipelineConfigurationArn()));
            }
            case "ResourceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.resourceAccessRoleArn()));
            }
            case "RealTimeAlertConfiguration": {
                return Optional.ofNullable(clazz.cast(this.realTimeAlertConfiguration()));
            }
            case "Elements": {
                return Optional.ofNullable(clazz.cast(this.elements()));
            }
            case "MediaInsightsPipelineConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.mediaInsightsPipelineConfigurationId()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MediaInsightsPipelineConfigurationName", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_NAME_FIELD);
        map.put("MediaInsightsPipelineConfigurationArn", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ARN_FIELD);
        map.put("ResourceAccessRoleArn", RESOURCE_ACCESS_ROLE_ARN_FIELD);
        map.put("RealTimeAlertConfiguration", REAL_TIME_ALERT_CONFIGURATION_FIELD);
        map.put("Elements", ELEMENTS_FIELD);
        map.put("MediaInsightsPipelineConfigurationId", MEDIA_INSIGHTS_PIPELINE_CONFIGURATION_ID_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaInsightsPipelineConfiguration, T> g) {
        return obj -> g.apply((MediaInsightsPipelineConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mediaInsightsPipelineConfigurationName;
        private String mediaInsightsPipelineConfigurationArn;
        private String resourceAccessRoleArn;
        private RealTimeAlertConfiguration realTimeAlertConfiguration;
        private List<MediaInsightsPipelineConfigurationElement> elements = DefaultSdkAutoConstructList.getInstance();
        private String mediaInsightsPipelineConfigurationId;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaInsightsPipelineConfiguration model) {
            this.mediaInsightsPipelineConfigurationName(model.mediaInsightsPipelineConfigurationName);
            this.mediaInsightsPipelineConfigurationArn(model.mediaInsightsPipelineConfigurationArn);
            this.resourceAccessRoleArn(model.resourceAccessRoleArn);
            this.realTimeAlertConfiguration(model.realTimeAlertConfiguration);
            this.elements(model.elements);
            this.mediaInsightsPipelineConfigurationId(model.mediaInsightsPipelineConfigurationId);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getMediaInsightsPipelineConfigurationName() {
            return this.mediaInsightsPipelineConfigurationName;
        }

        public final void setMediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationName(String mediaInsightsPipelineConfigurationName) {
            this.mediaInsightsPipelineConfigurationName = mediaInsightsPipelineConfigurationName;
            return this;
        }

        public final String getMediaInsightsPipelineConfigurationArn() {
            return this.mediaInsightsPipelineConfigurationArn;
        }

        public final void setMediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationArn(String mediaInsightsPipelineConfigurationArn) {
            this.mediaInsightsPipelineConfigurationArn = mediaInsightsPipelineConfigurationArn;
            return this;
        }

        public final String getResourceAccessRoleArn() {
            return this.resourceAccessRoleArn;
        }

        public final void setResourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
        }

        @Override
        public final Builder resourceAccessRoleArn(String resourceAccessRoleArn) {
            this.resourceAccessRoleArn = resourceAccessRoleArn;
            return this;
        }

        public final RealTimeAlertConfiguration.Builder getRealTimeAlertConfiguration() {
            return this.realTimeAlertConfiguration != null ? this.realTimeAlertConfiguration.toBuilder() : null;
        }

        public final void setRealTimeAlertConfiguration(RealTimeAlertConfiguration.BuilderImpl realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration != null ? realTimeAlertConfiguration.build() : null;
        }

        @Override
        public final Builder realTimeAlertConfiguration(RealTimeAlertConfiguration realTimeAlertConfiguration) {
            this.realTimeAlertConfiguration = realTimeAlertConfiguration;
            return this;
        }

        public final List<MediaInsightsPipelineConfigurationElement.Builder> getElements() {
            List<MediaInsightsPipelineConfigurationElement.Builder> result = MediaInsightsPipelineConfigurationElementsCopier.copyToBuilder(this.elements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElements(Collection<MediaInsightsPipelineConfigurationElement.BuilderImpl> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copyFromBuilder(elements);
        }

        @Override
        public final Builder elements(Collection<MediaInsightsPipelineConfigurationElement> elements) {
            this.elements = MediaInsightsPipelineConfigurationElementsCopier.copy(elements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(MediaInsightsPipelineConfigurationElement ... elements) {
            this.elements(Arrays.asList(elements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder> ... elements) {
            this.elements(Stream.of(elements).map(c -> (MediaInsightsPipelineConfigurationElement)((MediaInsightsPipelineConfigurationElement.Builder)MediaInsightsPipelineConfigurationElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMediaInsightsPipelineConfigurationId() {
            return this.mediaInsightsPipelineConfigurationId;
        }

        public final void setMediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId) {
            this.mediaInsightsPipelineConfigurationId = mediaInsightsPipelineConfigurationId;
        }

        @Override
        public final Builder mediaInsightsPipelineConfigurationId(String mediaInsightsPipelineConfigurationId) {
            this.mediaInsightsPipelineConfigurationId = mediaInsightsPipelineConfigurationId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public MediaInsightsPipelineConfiguration build() {
            return new MediaInsightsPipelineConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaInsightsPipelineConfiguration> {
        public Builder mediaInsightsPipelineConfigurationName(String var1);

        public Builder mediaInsightsPipelineConfigurationArn(String var1);

        public Builder resourceAccessRoleArn(String var1);

        public Builder realTimeAlertConfiguration(RealTimeAlertConfiguration var1);

        default public Builder realTimeAlertConfiguration(Consumer<RealTimeAlertConfiguration.Builder> realTimeAlertConfiguration) {
            return this.realTimeAlertConfiguration((RealTimeAlertConfiguration)((RealTimeAlertConfiguration.Builder)RealTimeAlertConfiguration.builder().applyMutation(realTimeAlertConfiguration)).build());
        }

        public Builder elements(Collection<MediaInsightsPipelineConfigurationElement> var1);

        public Builder elements(MediaInsightsPipelineConfigurationElement ... var1);

        public Builder elements(Consumer<MediaInsightsPipelineConfigurationElement.Builder> ... var1);

        public Builder mediaInsightsPipelineConfigurationId(String var1);

        public Builder createdTimestamp(Instant var1);

        public Builder updatedTimestamp(Instant var1);
    }
}

