/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.ChimeSdkMediaPipelinesRequest;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.KinesisVideoStreamSourceTaskConfiguration;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.VoiceAnalyticsLanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartVoiceToneAnalysisTaskRequest
extends ChimeSdkMediaPipelinesRequest
implements ToCopyableBuilder<Builder, StartVoiceToneAnalysisTaskRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(StartVoiceToneAnalysisTaskRequest.getter(StartVoiceToneAnalysisTaskRequest::identifier)).setter(StartVoiceToneAnalysisTaskRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(StartVoiceToneAnalysisTaskRequest.getter(StartVoiceToneAnalysisTaskRequest::languageCodeAsString)).setter(StartVoiceToneAnalysisTaskRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<KinesisVideoStreamSourceTaskConfiguration> KINESIS_VIDEO_STREAM_SOURCE_TASK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisVideoStreamSourceTaskConfiguration").getter(StartVoiceToneAnalysisTaskRequest.getter(StartVoiceToneAnalysisTaskRequest::kinesisVideoStreamSourceTaskConfiguration)).setter(StartVoiceToneAnalysisTaskRequest.setter(Builder::kinesisVideoStreamSourceTaskConfiguration)).constructor(KinesisVideoStreamSourceTaskConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisVideoStreamSourceTaskConfiguration").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartVoiceToneAnalysisTaskRequest.getter(StartVoiceToneAnalysisTaskRequest::clientRequestToken)).setter(StartVoiceToneAnalysisTaskRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, LANGUAGE_CODE_FIELD, KINESIS_VIDEO_STREAM_SOURCE_TASK_CONFIGURATION_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartVoiceToneAnalysisTaskRequest.memberNameToFieldInitializer();
    private final String identifier;
    private final String languageCode;
    private final KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration;
    private final String clientRequestToken;

    private StartVoiceToneAnalysisTaskRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.languageCode = builder.languageCode;
        this.kinesisVideoStreamSourceTaskConfiguration = builder.kinesisVideoStreamSourceTaskConfiguration;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final VoiceAnalyticsLanguageCode languageCode() {
        return VoiceAnalyticsLanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration() {
        return this.kinesisVideoStreamSourceTaskConfiguration;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisVideoStreamSourceTaskConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartVoiceToneAnalysisTaskRequest)) {
            return false;
        }
        StartVoiceToneAnalysisTaskRequest other = (StartVoiceToneAnalysisTaskRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.kinesisVideoStreamSourceTaskConfiguration(), other.kinesisVideoStreamSourceTaskConfiguration()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartVoiceToneAnalysisTaskRequest").add("Identifier", (Object)this.identifier()).add("LanguageCode", (Object)this.languageCodeAsString()).add("KinesisVideoStreamSourceTaskConfiguration", (Object)this.kinesisVideoStreamSourceTaskConfiguration()).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "KinesisVideoStreamSourceTaskConfiguration": {
                return Optional.ofNullable(clazz.cast(this.kinesisVideoStreamSourceTaskConfiguration()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("KinesisVideoStreamSourceTaskConfiguration", KINESIS_VIDEO_STREAM_SOURCE_TASK_CONFIGURATION_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartVoiceToneAnalysisTaskRequest, T> g) {
        return obj -> g.apply((StartVoiceToneAnalysisTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMediaPipelinesRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String languageCode;
        private KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartVoiceToneAnalysisTaskRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.languageCode(model.languageCode);
            this.kinesisVideoStreamSourceTaskConfiguration(model.kinesisVideoStreamSourceTaskConfiguration);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(VoiceAnalyticsLanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final KinesisVideoStreamSourceTaskConfiguration.Builder getKinesisVideoStreamSourceTaskConfiguration() {
            return this.kinesisVideoStreamSourceTaskConfiguration != null ? this.kinesisVideoStreamSourceTaskConfiguration.toBuilder() : null;
        }

        public final void setKinesisVideoStreamSourceTaskConfiguration(KinesisVideoStreamSourceTaskConfiguration.BuilderImpl kinesisVideoStreamSourceTaskConfiguration) {
            this.kinesisVideoStreamSourceTaskConfiguration = kinesisVideoStreamSourceTaskConfiguration != null ? kinesisVideoStreamSourceTaskConfiguration.build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamSourceTaskConfiguration(KinesisVideoStreamSourceTaskConfiguration kinesisVideoStreamSourceTaskConfiguration) {
            this.kinesisVideoStreamSourceTaskConfiguration = kinesisVideoStreamSourceTaskConfiguration;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartVoiceToneAnalysisTaskRequest build() {
            return new StartVoiceToneAnalysisTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkMediaPipelinesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartVoiceToneAnalysisTaskRequest> {
        public Builder identifier(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(VoiceAnalyticsLanguageCode var1);

        public Builder kinesisVideoStreamSourceTaskConfiguration(KinesisVideoStreamSourceTaskConfiguration var1);

        default public Builder kinesisVideoStreamSourceTaskConfiguration(Consumer<KinesisVideoStreamSourceTaskConfiguration.Builder> kinesisVideoStreamSourceTaskConfiguration) {
            return this.kinesisVideoStreamSourceTaskConfiguration((KinesisVideoStreamSourceTaskConfiguration)((KinesisVideoStreamSourceTaskConfiguration.Builder)KinesisVideoStreamSourceTaskConfiguration.builder().applyMutation(kinesisVideoStreamSourceTaskConfiguration)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

