/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.ChangeAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeSetHookResourceTargetDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeSetHookResourceTargetDetails> {
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalResourceId").getter(ChangeSetHookResourceTargetDetails.getter(ChangeSetHookResourceTargetDetails::logicalResourceId)).setter(ChangeSetHookResourceTargetDetails.setter(Builder::logicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ChangeSetHookResourceTargetDetails.getter(ChangeSetHookResourceTargetDetails::resourceType)).setter(ChangeSetHookResourceTargetDetails.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceAction").getter(ChangeSetHookResourceTargetDetails.getter(ChangeSetHookResourceTargetDetails::resourceActionAsString)).setter(ChangeSetHookResourceTargetDetails.setter(Builder::resourceAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeSetHookResourceTargetDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logicalResourceId;
    private final String resourceType;
    private final String resourceAction;

    private ChangeSetHookResourceTargetDetails(BuilderImpl builder) {
        this.logicalResourceId = builder.logicalResourceId;
        this.resourceType = builder.resourceType;
        this.resourceAction = builder.resourceAction;
    }

    public final String logicalResourceId() {
        return this.logicalResourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final ChangeAction resourceAction() {
        return ChangeAction.fromValue(this.resourceAction);
    }

    public final String resourceActionAsString() {
        return this.resourceAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetHookResourceTargetDetails)) {
            return false;
        }
        ChangeSetHookResourceTargetDetails other = (ChangeSetHookResourceTargetDetails)obj;
        return Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.resourceActionAsString(), other.resourceActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeSetHookResourceTargetDetails").add("LogicalResourceId", (Object)this.logicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("ResourceAction", (Object)this.resourceActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ResourceAction": {
                return Optional.ofNullable(clazz.cast(this.resourceActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LogicalResourceId", LOGICAL_RESOURCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceAction", RESOURCE_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeSetHookResourceTargetDetails, T> g) {
        return obj -> g.apply((ChangeSetHookResourceTargetDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logicalResourceId;
        private String resourceType;
        private String resourceAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetHookResourceTargetDetails model) {
            this.logicalResourceId(model.logicalResourceId);
            this.resourceType(model.resourceType);
            this.resourceAction(model.resourceAction);
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceAction() {
            return this.resourceAction;
        }

        public final void setResourceAction(String resourceAction) {
            this.resourceAction = resourceAction;
        }

        @Override
        public final Builder resourceAction(String resourceAction) {
            this.resourceAction = resourceAction;
            return this;
        }

        @Override
        public final Builder resourceAction(ChangeAction resourceAction) {
            this.resourceAction(resourceAction == null ? null : resourceAction.toString());
            return this;
        }

        public ChangeSetHookResourceTargetDetails build() {
            return new ChangeSetHookResourceTargetDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeSetHookResourceTargetDetails> {
        public Builder logicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceAction(String var1);

        public Builder resourceAction(ChangeAction var1);
    }
}

