/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListResourceScanRelatedResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.ScannedResource;

public class ListResourceScanRelatedResourcesIterable
implements SdkIterable<ListResourceScanRelatedResourcesResponse> {
    private final CloudFormationClient client;
    private final ListResourceScanRelatedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceScanRelatedResourcesIterable(CloudFormationClient client, ListResourceScanRelatedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceScanRelatedResourcesResponseFetcher();
    }

    public Iterator<ListResourceScanRelatedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScannedResource> relatedResources() {
        Function<ListResourceScanRelatedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.relatedResources() != null) {
                return response.relatedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceScanRelatedResourcesResponseFetcher
    implements SyncPageFetcher<ListResourceScanRelatedResourcesResponse> {
        private ListResourceScanRelatedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceScanRelatedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceScanRelatedResourcesResponse nextPage(ListResourceScanRelatedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListResourceScanRelatedResourcesIterable.this.client.listResourceScanRelatedResources(ListResourceScanRelatedResourcesIterable.this.firstRequest);
            }
            return ListResourceScanRelatedResourcesIterable.this.client.listResourceScanRelatedResources((ListResourceScanRelatedResourcesRequest)((Object)ListResourceScanRelatedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

