/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRealtimeLogConfigResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, CreateRealtimeLogConfigResponse> {
    private static final SdkField<RealtimeLogConfig> REALTIME_LOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RealtimeLogConfig").getter(CreateRealtimeLogConfigResponse.getter(CreateRealtimeLogConfigResponse::realtimeLogConfig)).setter(CreateRealtimeLogConfigResponse.setter(Builder::realtimeLogConfig)).constructor(RealtimeLogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeLogConfig").unmarshallLocationName("RealtimeLogConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REALTIME_LOG_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRealtimeLogConfigResponse.memberNameToFieldInitializer();
    private final RealtimeLogConfig realtimeLogConfig;

    private CreateRealtimeLogConfigResponse(BuilderImpl builder) {
        super(builder);
        this.realtimeLogConfig = builder.realtimeLogConfig;
    }

    public final RealtimeLogConfig realtimeLogConfig() {
        return this.realtimeLogConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.realtimeLogConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRealtimeLogConfigResponse)) {
            return false;
        }
        CreateRealtimeLogConfigResponse other = (CreateRealtimeLogConfigResponse)((Object)obj);
        return Objects.equals(this.realtimeLogConfig(), other.realtimeLogConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRealtimeLogConfigResponse").add("RealtimeLogConfig", (Object)this.realtimeLogConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RealtimeLogConfig": {
                return Optional.ofNullable(clazz.cast(this.realtimeLogConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<RealtimeLogConfig>> map = new HashMap<String, SdkField<RealtimeLogConfig>>();
        map.put("RealtimeLogConfig", REALTIME_LOG_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRealtimeLogConfigResponse, T> g) {
        return obj -> g.apply((CreateRealtimeLogConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private RealtimeLogConfig realtimeLogConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRealtimeLogConfigResponse model) {
            super(model);
            this.realtimeLogConfig(model.realtimeLogConfig);
        }

        public final RealtimeLogConfig.Builder getRealtimeLogConfig() {
            return this.realtimeLogConfig != null ? this.realtimeLogConfig.toBuilder() : null;
        }

        public final void setRealtimeLogConfig(RealtimeLogConfig.BuilderImpl realtimeLogConfig) {
            this.realtimeLogConfig = realtimeLogConfig != null ? realtimeLogConfig.build() : null;
        }

        @Override
        public final Builder realtimeLogConfig(RealtimeLogConfig realtimeLogConfig) {
            this.realtimeLogConfig = realtimeLogConfig;
            return this;
        }

        @Override
        public CreateRealtimeLogConfigResponse build() {
            return new CreateRealtimeLogConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRealtimeLogConfigResponse> {
        public Builder realtimeLogConfig(RealtimeLogConfig var1);

        default public Builder realtimeLogConfig(Consumer<RealtimeLogConfig.Builder> realtimeLogConfig) {
            return this.realtimeLogConfig((RealtimeLogConfig)((RealtimeLogConfig.Builder)RealtimeLogConfig.builder().applyMutation(realtimeLogConfig)).build());
        }
    }
}

