/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionTenantListCopier;
import software.amazon.awssdk.services.cloudfront.model.DistributionTenantSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDistributionTenantsResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListDistributionTenantsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListDistributionTenantsResponse.getter(ListDistributionTenantsResponse::nextMarker)).setter(ListDistributionTenantsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").unmarshallLocationName("NextMarker").build()}).build();
    private static final SdkField<List<DistributionTenantSummary>> DISTRIBUTION_TENANT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DistributionTenantList").getter(ListDistributionTenantsResponse.getter(ListDistributionTenantsResponse::distributionTenantList)).setter(ListDistributionTenantsResponse.setter(Builder::distributionTenantList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionTenantList").unmarshallLocationName("DistributionTenantList").build(), ListTrait.builder().memberLocationName("DistributionTenantSummary").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DistributionTenantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionTenantSummary").unmarshallLocationName("DistributionTenantSummary").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD, DISTRIBUTION_TENANT_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDistributionTenantsResponse.memberNameToFieldInitializer();
    private final String nextMarker;
    private final List<DistributionTenantSummary> distributionTenantList;

    private ListDistributionTenantsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.distributionTenantList = builder.distributionTenantList;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final boolean hasDistributionTenantList() {
        return this.distributionTenantList != null && !(this.distributionTenantList instanceof SdkAutoConstructList);
    }

    public final List<DistributionTenantSummary> distributionTenantList() {
        return this.distributionTenantList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistributionTenantList() ? this.distributionTenantList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDistributionTenantsResponse)) {
            return false;
        }
        ListDistributionTenantsResponse other = (ListDistributionTenantsResponse)((Object)obj);
        return Objects.equals(this.nextMarker(), other.nextMarker()) && this.hasDistributionTenantList() == other.hasDistributionTenantList() && Objects.equals(this.distributionTenantList(), other.distributionTenantList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDistributionTenantsResponse").add("NextMarker", (Object)this.nextMarker()).add("DistributionTenantList", this.hasDistributionTenantList() ? this.distributionTenantList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "DistributionTenantList": {
                return Optional.ofNullable(clazz.cast(this.distributionTenantList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("DistributionTenantList", DISTRIBUTION_TENANT_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDistributionTenantsResponse, T> g) {
        return obj -> g.apply((ListDistributionTenantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private String nextMarker;
        private List<DistributionTenantSummary> distributionTenantList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDistributionTenantsResponse model) {
            super(model);
            this.nextMarker(model.nextMarker);
            this.distributionTenantList(model.distributionTenantList);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<DistributionTenantSummary.Builder> getDistributionTenantList() {
            List<DistributionTenantSummary.Builder> result = DistributionTenantListCopier.copyToBuilder(this.distributionTenantList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistributionTenantList(Collection<DistributionTenantSummary.BuilderImpl> distributionTenantList) {
            this.distributionTenantList = DistributionTenantListCopier.copyFromBuilder(distributionTenantList);
        }

        @Override
        public final Builder distributionTenantList(Collection<DistributionTenantSummary> distributionTenantList) {
            this.distributionTenantList = DistributionTenantListCopier.copy(distributionTenantList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributionTenantList(DistributionTenantSummary ... distributionTenantList) {
            this.distributionTenantList(Arrays.asList(distributionTenantList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distributionTenantList(Consumer<DistributionTenantSummary.Builder> ... distributionTenantList) {
            this.distributionTenantList(Stream.of(distributionTenantList).map(c -> (DistributionTenantSummary)((DistributionTenantSummary.Builder)DistributionTenantSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDistributionTenantsResponse build() {
            return new ListDistributionTenantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDistributionTenantsResponse> {
        public Builder nextMarker(String var1);

        public Builder distributionTenantList(Collection<DistributionTenantSummary> var1);

        public Builder distributionTenantList(DistributionTenantSummary ... var1);

        public Builder distributionTenantList(Consumer<DistributionTenantSummary.Builder> ... var1);
    }
}

