/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrustStoreConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrustStoreConfig> {
    private static final SdkField<String> TRUST_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreId").getter(TrustStoreConfig.getter(TrustStoreConfig::trustStoreId)).setter(TrustStoreConfig.setter(Builder::trustStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreId").unmarshallLocationName("TrustStoreId").build()}).build();
    private static final SdkField<Boolean> ADVERTISE_TRUST_STORE_CA_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AdvertiseTrustStoreCaNames").getter(TrustStoreConfig.getter(TrustStoreConfig::advertiseTrustStoreCaNames)).setter(TrustStoreConfig.setter(Builder::advertiseTrustStoreCaNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvertiseTrustStoreCaNames").unmarshallLocationName("AdvertiseTrustStoreCaNames").build()}).build();
    private static final SdkField<Boolean> IGNORE_CERTIFICATE_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IgnoreCertificateExpiry").getter(TrustStoreConfig.getter(TrustStoreConfig::ignoreCertificateExpiry)).setter(TrustStoreConfig.setter(Builder::ignoreCertificateExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IgnoreCertificateExpiry").unmarshallLocationName("IgnoreCertificateExpiry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ID_FIELD, ADVERTISE_TRUST_STORE_CA_NAMES_FIELD, IGNORE_CERTIFICATE_EXPIRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrustStoreConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trustStoreId;
    private final Boolean advertiseTrustStoreCaNames;
    private final Boolean ignoreCertificateExpiry;

    private TrustStoreConfig(BuilderImpl builder) {
        this.trustStoreId = builder.trustStoreId;
        this.advertiseTrustStoreCaNames = builder.advertiseTrustStoreCaNames;
        this.ignoreCertificateExpiry = builder.ignoreCertificateExpiry;
    }

    public final String trustStoreId() {
        return this.trustStoreId;
    }

    public final Boolean advertiseTrustStoreCaNames() {
        return this.advertiseTrustStoreCaNames;
    }

    public final Boolean ignoreCertificateExpiry() {
        return this.ignoreCertificateExpiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.advertiseTrustStoreCaNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreCertificateExpiry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustStoreConfig)) {
            return false;
        }
        TrustStoreConfig other = (TrustStoreConfig)obj;
        return Objects.equals(this.trustStoreId(), other.trustStoreId()) && Objects.equals(this.advertiseTrustStoreCaNames(), other.advertiseTrustStoreCaNames()) && Objects.equals(this.ignoreCertificateExpiry(), other.ignoreCertificateExpiry());
    }

    public final String toString() {
        return ToString.builder((String)"TrustStoreConfig").add("TrustStoreId", (Object)this.trustStoreId()).add("AdvertiseTrustStoreCaNames", (Object)this.advertiseTrustStoreCaNames()).add("IgnoreCertificateExpiry", (Object)this.ignoreCertificateExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStoreId": {
                return Optional.ofNullable(clazz.cast(this.trustStoreId()));
            }
            case "AdvertiseTrustStoreCaNames": {
                return Optional.ofNullable(clazz.cast(this.advertiseTrustStoreCaNames()));
            }
            case "IgnoreCertificateExpiry": {
                return Optional.ofNullable(clazz.cast(this.ignoreCertificateExpiry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustStoreId", TRUST_STORE_ID_FIELD);
        map.put("AdvertiseTrustStoreCaNames", ADVERTISE_TRUST_STORE_CA_NAMES_FIELD);
        map.put("IgnoreCertificateExpiry", IGNORE_CERTIFICATE_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustStoreConfig, T> g) {
        return obj -> g.apply((TrustStoreConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trustStoreId;
        private Boolean advertiseTrustStoreCaNames;
        private Boolean ignoreCertificateExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(TrustStoreConfig model) {
            this.trustStoreId(model.trustStoreId);
            this.advertiseTrustStoreCaNames(model.advertiseTrustStoreCaNames);
            this.ignoreCertificateExpiry(model.ignoreCertificateExpiry);
        }

        public final String getTrustStoreId() {
            return this.trustStoreId;
        }

        public final void setTrustStoreId(String trustStoreId) {
            this.trustStoreId = trustStoreId;
        }

        @Override
        public final Builder trustStoreId(String trustStoreId) {
            this.trustStoreId = trustStoreId;
            return this;
        }

        public final Boolean getAdvertiseTrustStoreCaNames() {
            return this.advertiseTrustStoreCaNames;
        }

        public final void setAdvertiseTrustStoreCaNames(Boolean advertiseTrustStoreCaNames) {
            this.advertiseTrustStoreCaNames = advertiseTrustStoreCaNames;
        }

        @Override
        public final Builder advertiseTrustStoreCaNames(Boolean advertiseTrustStoreCaNames) {
            this.advertiseTrustStoreCaNames = advertiseTrustStoreCaNames;
            return this;
        }

        public final Boolean getIgnoreCertificateExpiry() {
            return this.ignoreCertificateExpiry;
        }

        public final void setIgnoreCertificateExpiry(Boolean ignoreCertificateExpiry) {
            this.ignoreCertificateExpiry = ignoreCertificateExpiry;
        }

        @Override
        public final Builder ignoreCertificateExpiry(Boolean ignoreCertificateExpiry) {
            this.ignoreCertificateExpiry = ignoreCertificateExpiry;
            return this;
        }

        public TrustStoreConfig build() {
            return new TrustStoreConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrustStoreConfig> {
        public Builder trustStoreId(String var1);

        public Builder advertiseTrustStoreCaNames(Boolean var1);

        public Builder ignoreCertificateExpiry(Boolean var1);
    }
}

