/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.ConnectionGroupSummary;
import software.amazon.awssdk.services.cloudfront.model.ListConnectionGroupsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConnectionGroupsResponse;

public class ListConnectionGroupsIterable
implements SdkIterable<ListConnectionGroupsResponse> {
    private final CloudFrontClient client;
    private final ListConnectionGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectionGroupsIterable(CloudFrontClient client, ListConnectionGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectionGroupsResponseFetcher();
    }

    public Iterator<ListConnectionGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectionGroupSummary> connectionGroups() {
        Function<ListConnectionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectionGroups() != null) {
                return response.connectionGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectionGroupsResponseFetcher
    implements SyncPageFetcher<ListConnectionGroupsResponse> {
        private ListConnectionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListConnectionGroupsResponse nextPage(ListConnectionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectionGroupsIterable.this.client.listConnectionGroups(ListConnectionGroupsIterable.this.firstRequest);
            }
            return ListConnectionGroupsIterable.this.client.listConnectionGroups((ListConnectionGroupsRequest)((Object)ListConnectionGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

